/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.alibabacloudsearch.action;

import java.util.Map;
import java.util.Objects;
import org.elasticsearch.xpack.inference.external.action.ActionUtils;
import org.elasticsearch.xpack.inference.external.action.ExecutableAction;
import org.elasticsearch.xpack.inference.external.action.SenderExecutableAction;
import org.elasticsearch.xpack.inference.external.http.sender.Sender;
import org.elasticsearch.xpack.inference.services.ServiceComponents;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchAccount;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchCompletionRequestManager;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchEmbeddingsRequestManager;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchRerankRequestManager;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.AlibabaCloudSearchSparseRequestManager;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.action.AlibabaCloudSearchActionVisitor;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.completion.AlibabaCloudSearchCompletionModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.embeddings.AlibabaCloudSearchEmbeddingsModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.rerank.AlibabaCloudSearchRerankModel;
import org.elasticsearch.xpack.inference.services.alibabacloudsearch.sparse.AlibabaCloudSearchSparseModel;

public class AlibabaCloudSearchActionCreator
implements AlibabaCloudSearchActionVisitor {
    private final Sender sender;
    private final ServiceComponents serviceComponents;

    public AlibabaCloudSearchActionCreator(Sender sender, ServiceComponents serviceComponents) {
        this.sender = Objects.requireNonNull(sender);
        this.serviceComponents = Objects.requireNonNull(serviceComponents);
    }

    @Override
    public ExecutableAction create(AlibabaCloudSearchEmbeddingsModel model, Map<String, Object> taskSettings) {
        AlibabaCloudSearchEmbeddingsModel overriddenModel = AlibabaCloudSearchEmbeddingsModel.of(model, taskSettings);
        AlibabaCloudSearchAccount account = new AlibabaCloudSearchAccount(overriddenModel.getSecretSettings().apiKey());
        AlibabaCloudSearchEmbeddingsRequestManager requestManager = AlibabaCloudSearchEmbeddingsRequestManager.of(account, overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("AlibabaCloud Search text embeddings");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(AlibabaCloudSearchSparseModel model, Map<String, Object> taskSettings) {
        AlibabaCloudSearchSparseModel overriddenModel = AlibabaCloudSearchSparseModel.of(model, taskSettings);
        AlibabaCloudSearchAccount account = new AlibabaCloudSearchAccount(overriddenModel.getSecretSettings().apiKey());
        AlibabaCloudSearchSparseRequestManager requestManager = AlibabaCloudSearchSparseRequestManager.of(account, overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("AlibabaCloud Search sparse embeddings");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(AlibabaCloudSearchRerankModel model, Map<String, Object> taskSettings) {
        AlibabaCloudSearchRerankModel overriddenModel = AlibabaCloudSearchRerankModel.of(model, taskSettings);
        AlibabaCloudSearchAccount account = new AlibabaCloudSearchAccount(overriddenModel.getSecretSettings().apiKey());
        AlibabaCloudSearchRerankRequestManager requestManager = AlibabaCloudSearchRerankRequestManager.of(account, overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("AlibabaCloud Search rerank");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }

    @Override
    public ExecutableAction create(AlibabaCloudSearchCompletionModel model, Map<String, Object> taskSettings) {
        AlibabaCloudSearchCompletionModel overriddenModel = AlibabaCloudSearchCompletionModel.of(model, taskSettings);
        AlibabaCloudSearchAccount account = new AlibabaCloudSearchAccount(overriddenModel.getSecretSettings().apiKey());
        AlibabaCloudSearchCompletionRequestManager requestManager = AlibabaCloudSearchCompletionRequestManager.of(account, overriddenModel, this.serviceComponents.threadPool());
        String failedToSendRequestErrorMessage = ActionUtils.constructFailedToSendRequestMessage("AlibabaCloud Search completion");
        return new SenderExecutableAction(this.sender, requestManager, failedToSendRequestErrorMessage);
    }
}

