/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.rank.textsimilarity;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.ScoreDoc;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.inference.ChunkingSettings;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.rank.RankBuilder;
import org.elasticsearch.search.rank.RankDoc;
import org.elasticsearch.search.retriever.CompoundRetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverBuilder;
import org.elasticsearch.search.retriever.RetrieverParserContext;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.inference.rank.textsimilarity.ChunkScorerConfig;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankBuilder;
import org.elasticsearch.xpack.inference.rank.textsimilarity.TextSimilarityRankDoc;

public class TextSimilarityRankRetrieverBuilder
extends CompoundRetrieverBuilder<TextSimilarityRankRetrieverBuilder> {
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_ALIAS_HANDLING_FIX = new NodeFeature("text_similarity_reranker_alias_handling_fix");
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_MINSCORE_FIX = new NodeFeature("text_similarity_reranker_minscore_fix");
    public static final NodeFeature TEXT_SIMILARITY_RERANKER_SNIPPETS = new NodeFeature("text_similarity_reranker_snippets");
    public static final ParseField RETRIEVER_FIELD = new ParseField("retriever", new String[0]);
    public static final ParseField INFERENCE_ID_FIELD = new ParseField("inference_id", new String[0]);
    public static final ParseField INFERENCE_TEXT_FIELD = new ParseField("inference_text", new String[0]);
    public static final ParseField FIELD_FIELD = new ParseField("field", new String[0]);
    public static final ParseField FAILURES_ALLOWED_FIELD = new ParseField("allow_rerank_failures", new String[0]);
    public static final ParseField CHUNK_RESCORER_FIELD = new ParseField("chunk_rescorer", new String[0]);
    public static final ParseField CHUNK_SIZE_FIELD = new ParseField("size", new String[0]);
    public static final ParseField CHUNKING_SETTINGS_FIELD = new ParseField("chunking_settings", new String[0]);
    public static final ConstructingObjectParser<TextSimilarityRankRetrieverBuilder, RetrieverParserContext> PARSER = new ConstructingObjectParser("text_similarity_reranker", args -> {
        RetrieverBuilder retrieverBuilder = (RetrieverBuilder)args[0];
        String inferenceId = args[1] == null ? ".rerank-v1-elasticsearch" : (String)args[1];
        String inferenceText = (String)args[2];
        String field = (String)args[3];
        int rankWindowSize = args[4] == null ? 10 : (Integer)args[4];
        boolean failuresAllowed = args[5] != null && (Boolean)args[5] != false;
        ChunkScorerConfig chunkScorerConfig = (ChunkScorerConfig)args[6];
        return new TextSimilarityRankRetrieverBuilder(retrieverBuilder, inferenceId, inferenceText, field, rankWindowSize, failuresAllowed, chunkScorerConfig);
    });
    private static final ConstructingObjectParser<ChunkScorerConfig, RetrieverParserContext> CHUNK_SCORER_PARSER = new ConstructingObjectParser(CHUNK_RESCORER_FIELD.getPreferredName(), true, args -> {
        Integer size = (Integer)args[0];
        Map chunkingSettingsMap = (Map)args[1];
        ChunkingSettings chunkingSettings = ChunkScorerConfig.chunkingSettingsFromMap(chunkingSettingsMap);
        return new ChunkScorerConfig(size, chunkingSettings);
    });
    private final String inferenceId;
    private final String inferenceText;
    private final String field;
    private final boolean failuresAllowed;
    private final ChunkScorerConfig chunkScorerConfig;

    public static TextSimilarityRankRetrieverBuilder fromXContent(XContentParser parser, RetrieverParserContext context, XPackLicenseState licenceState) throws IOException {
        if (!TextSimilarityRankBuilder.TEXT_SIMILARITY_RERANKER_FEATURE.check(licenceState)) {
            throw LicenseUtils.newComplianceException((String)"text_similarity_reranker");
        }
        return (TextSimilarityRankRetrieverBuilder)((Object)PARSER.apply(parser, (Object)context));
    }

    public TextSimilarityRankRetrieverBuilder(RetrieverBuilder retrieverBuilder, String inferenceId, String inferenceText, String field, int rankWindowSize, boolean failuresAllowed, ChunkScorerConfig chunkScorerConfig) {
        super(List.of(CompoundRetrieverBuilder.RetrieverSource.from((RetrieverBuilder)retrieverBuilder)), rankWindowSize);
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.failuresAllowed = failuresAllowed;
        this.chunkScorerConfig = chunkScorerConfig;
    }

    public TextSimilarityRankRetrieverBuilder(List<CompoundRetrieverBuilder.RetrieverSource> retrieverSource, String inferenceId, String inferenceText, String field, int rankWindowSize, Float minScore, boolean failuresAllowed, String retrieverName, List<QueryBuilder> preFilterQueryBuilders, ChunkScorerConfig chunkScorerConfig) {
        super(retrieverSource, rankWindowSize);
        if (retrieverSource.size() != 1) {
            throw new IllegalArgumentException("[" + this.getName() + "] retriever should have exactly one inner retriever");
        }
        if (chunkScorerConfig != null && chunkScorerConfig.size() != null && chunkScorerConfig.size() < 1) {
            throw new IllegalArgumentException("size must be greater than 0, was: " + chunkScorerConfig.size());
        }
        this.inferenceId = inferenceId;
        this.inferenceText = inferenceText;
        this.field = field;
        this.minScore = minScore;
        this.failuresAllowed = failuresAllowed;
        this.retrieverName = retrieverName;
        this.preFilterQueryBuilders = preFilterQueryBuilders;
        this.chunkScorerConfig = chunkScorerConfig;
    }

    protected TextSimilarityRankRetrieverBuilder clone(List<CompoundRetrieverBuilder.RetrieverSource> newChildRetrievers, List<QueryBuilder> newPreFilterQueryBuilders) {
        return new TextSimilarityRankRetrieverBuilder(newChildRetrievers, this.inferenceId, this.inferenceText, this.field, this.rankWindowSize, this.minScore, this.failuresAllowed, this.retrieverName, newPreFilterQueryBuilders, this.chunkScorerConfig);
    }

    protected RankDoc[] combineInnerRetrieverResults(List<ScoreDoc[]> rankResults, boolean explain) {
        assert (rankResults.size() == 1);
        ScoreDoc[] scoreDocs = rankResults.getFirst();
        ArrayList<TextSimilarityRankDoc> filteredDocs = new ArrayList<TextSimilarityRankDoc>();
        for (int i = 0; i < scoreDocs.length; ++i) {
            ScoreDoc scoreDoc = scoreDocs[i];
            assert (scoreDoc.score >= 0.0f);
            if (this.minScore != null && !(scoreDoc.score >= this.minScore.floatValue())) continue;
            if (explain) {
                filteredDocs.add(new TextSimilarityRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex, this.inferenceId, this.field));
                continue;
            }
            filteredDocs.add(new TextSimilarityRankDoc(scoreDoc.doc, scoreDoc.score, scoreDoc.shardIndex));
        }
        return filteredDocs.toArray(new TextSimilarityRankDoc[0]);
    }

    protected SearchSourceBuilder finalizeSourceBuilder(SearchSourceBuilder sourceBuilder) {
        sourceBuilder.rankBuilder((RankBuilder)new TextSimilarityRankBuilder(this.field, this.inferenceId, this.inferenceText, this.rankWindowSize, this.minScore, this.failuresAllowed, this.chunkScorerConfig != null ? new ChunkScorerConfig(this.chunkScorerConfig.size, this.inferenceText, this.chunkScorerConfig.chunkingSettings()) : null));
        return sourceBuilder;
    }

    public Set<String> getExtendedUsageFields() {
        HashSet<String> extendedFields = new HashSet<String>();
        if (this.chunkScorerConfig != null) {
            extendedFields.add(CHUNK_RESCORER_FIELD.getPreferredName());
        }
        return extendedFields;
    }

    public String getName() {
        return "text_similarity_reranker";
    }

    public String inferenceId() {
        return this.inferenceId;
    }

    public boolean failuresAllowed() {
        return this.failuresAllowed;
    }

    protected void doToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(RETRIEVER_FIELD.getPreferredName(), (ToXContent)((CompoundRetrieverBuilder.RetrieverSource)this.innerRetrievers.getFirst()).retriever());
        builder.field(INFERENCE_ID_FIELD.getPreferredName(), this.inferenceId);
        builder.field(INFERENCE_TEXT_FIELD.getPreferredName(), this.inferenceText);
        builder.field(FIELD_FIELD.getPreferredName(), this.field);
        builder.field(RANK_WINDOW_SIZE_FIELD.getPreferredName(), this.rankWindowSize);
        if (this.failuresAllowed) {
            builder.field(FAILURES_ALLOWED_FIELD.getPreferredName(), this.failuresAllowed);
        }
        if (this.chunkScorerConfig != null) {
            builder.startObject(CHUNK_RESCORER_FIELD.getPreferredName());
            if (this.chunkScorerConfig.size() != null) {
                builder.field(CHUNK_SIZE_FIELD.getPreferredName(), this.chunkScorerConfig.size());
            }
            if (this.chunkScorerConfig.chunkingSettings() != null) {
                builder.field(CHUNKING_SETTINGS_FIELD.getPreferredName(), this.chunkScorerConfig.chunkingSettings().asMap());
            }
            builder.endObject();
        }
    }

    public boolean doEquals(Object other) {
        TextSimilarityRankRetrieverBuilder that = (TextSimilarityRankRetrieverBuilder)((Object)other);
        return super.doEquals(other) && Objects.equals(this.inferenceId, that.inferenceId) && Objects.equals(this.inferenceText, that.inferenceText) && Objects.equals(this.field, that.field) && this.rankWindowSize == that.rankWindowSize && Objects.equals(this.minScore, that.minScore) && this.failuresAllowed == that.failuresAllowed && Objects.equals(this.chunkScorerConfig, that.chunkScorerConfig);
    }

    public int doHashCode() {
        return Objects.hash(this.inferenceId, this.inferenceText, this.field, this.rankWindowSize, this.minScore, this.failuresAllowed, this.chunkScorerConfig);
    }

    static {
        PARSER.declareNamedObject(ConstructingObjectParser.constructorArg(), (p, c, n) -> {
            RetrieverBuilder innerRetriever = (RetrieverBuilder)p.namedObject(RetrieverBuilder.class, n, c);
            c.trackRetrieverUsage(innerRetriever);
            return innerRetriever;
        }, RETRIEVER_FIELD);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), INFERENCE_ID_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), INFERENCE_TEXT_FIELD);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FIELD_FIELD);
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), RANK_WINDOW_SIZE_FIELD);
        PARSER.declareBoolean(ConstructingObjectParser.optionalConstructorArg(), FAILURES_ALLOWED_FIELD);
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), CHUNK_SCORER_PARSER, CHUNK_RESCORER_FIELD);
        CHUNK_SCORER_PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), CHUNK_SIZE_FIELD);
        CHUNK_SCORER_PARSER.declareObjectOrNull(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> p.map(), null, CHUNKING_SETTINGS_FIELD);
        RetrieverBuilder.declareBaseParserFields(PARSER);
    }
}

