/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.exchange;

import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.IsBlockedResult;
import org.elasticsearch.compute.operator.exchange.ExchangeBuffer;
import org.elasticsearch.compute.operator.exchange.ExchangeSink;
import org.elasticsearch.compute.operator.exchange.ExchangeSource;

public final class DirectExchange {
    private final ExchangeBuffer buffer;
    private final AtomicInteger pendingSinks = new AtomicInteger(0);
    private final AtomicInteger pendingSources = new AtomicInteger(0);

    public DirectExchange(int bufferSize) {
        this.buffer = new ExchangeBuffer(bufferSize);
    }

    public ExchangeSource exchangeSource() {
        return new DirectExchangeSource();
    }

    public ExchangeSink exchangeSink() {
        return new DirectExchangeSink();
    }

    final class DirectExchangeSource
    implements ExchangeSource {
        private boolean finished = false;

        DirectExchangeSource() {
            DirectExchange.this.pendingSources.incrementAndGet();
        }

        @Override
        public Page pollPage() {
            return DirectExchange.this.buffer.pollPage();
        }

        @Override
        public void finish() {
            this.finished = true;
            if (DirectExchange.this.pendingSources.decrementAndGet() == 0) {
                DirectExchange.this.buffer.finish(true);
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished || DirectExchange.this.buffer.isFinished();
        }

        @Override
        public int bufferSize() {
            return DirectExchange.this.buffer.size();
        }

        @Override
        public IsBlockedResult waitForReading() {
            return DirectExchange.this.buffer.waitForReading();
        }
    }

    final class DirectExchangeSink
    implements ExchangeSink {
        private boolean finished = false;

        DirectExchangeSink() {
            DirectExchange.this.pendingSinks.incrementAndGet();
        }

        @Override
        public void addPage(Page page) {
            DirectExchange.this.buffer.addPage(page);
        }

        @Override
        public void finish() {
            this.finished = true;
            if (DirectExchange.this.pendingSinks.decrementAndGet() == 0) {
                DirectExchange.this.buffer.finish(false);
            }
        }

        @Override
        public boolean isFinished() {
            return this.finished || DirectExchange.this.buffer.isFinished();
        }

        @Override
        public void addCompletionListener(ActionListener<Void> listener) {
            DirectExchange.this.buffer.addCompletionListener(listener);
        }

        @Override
        public IsBlockedResult waitForWriting() {
            return DirectExchange.this.buffer.waitForWriting();
        }
    }
}

