/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.AbstractPageMappingOperator;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

public class EvalOperator
extends AbstractPageMappingOperator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(EvalOperator.class);
    private final DriverContext ctx;
    private final ExpressionEvaluator evaluator;
    public static final ExpressionEvaluator.Factory CONSTANT_NULL_FACTORY = new ConstantNullEvaluator.Factory();
    public static final ExpressionEvaluator.Factory CONSTANT_TRUE_FACTORY = new ConstantTrueEvaluator.Factory();
    public static final ExpressionEvaluator.Factory CONSTANT_FALSE_FACTORY = new ConstantFalseEvaluator.Factory();

    public EvalOperator(DriverContext ctx, ExpressionEvaluator evaluator) {
        this.ctx = ctx;
        this.evaluator = evaluator;
        ctx.breaker().addEstimateBytesAndMaybeBreak(BASE_RAM_BYTES_USED + evaluator.baseRamBytesUsed(), "ESQL");
    }

    @Override
    protected Page process(Page page) {
        Block block = this.evaluator.eval(page);
        return page.appendBlock(block);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[evaluator=" + String.valueOf(this.evaluator) + "]";
    }

    @Override
    public void close() {
        Releasables.closeExpectNoException((Releasable[])new Releasable[]{this.evaluator, () -> this.ctx.breaker().addWithoutBreaking(-BASE_RAM_BYTES_USED - this.evaluator.baseRamBytesUsed()), () -> super.close()});
    }

    public static interface ExpressionEvaluator
    extends Releasable {
        public Block eval(Page var1);

        public long baseRamBytesUsed();

        public static interface Factory {
            public ExpressionEvaluator get(DriverContext var1);

            default public boolean eagerEvalSafeInLazy() {
                return false;
            }
        }
    }

    private record ConstantNullEvaluator(DriverContext context) implements ExpressionEvaluator
    {
        private static final String NAME = "ConstantNull";
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantNullEvaluator.class);

        @Override
        public Block eval(Page page) {
            return this.context.blockFactory().newConstantNullBlock(page.getPositionCount());
        }

        public void close() {
        }

        @Override
        public String toString() {
            return NAME;
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        record Factory() implements ExpressionEvaluator.Factory
        {
            @Override
            public ConstantNullEvaluator get(DriverContext context) {
                return new ConstantNullEvaluator(context);
            }

            @Override
            public String toString() {
                return ConstantNullEvaluator.NAME;
            }
        }
    }

    private record ConstantTrueEvaluator(DriverContext context) implements ExpressionEvaluator
    {
        private static final String NAME = "ConstantTrue";
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantTrueEvaluator.class);

        @Override
        public Block eval(Page page) {
            return this.context.blockFactory().newConstantBooleanBlockWith(true, page.getPositionCount());
        }

        public void close() {
        }

        @Override
        public String toString() {
            return NAME;
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        record Factory() implements ExpressionEvaluator.Factory
        {
            @Override
            public ConstantTrueEvaluator get(DriverContext context) {
                return new ConstantTrueEvaluator(context);
            }

            @Override
            public String toString() {
                return ConstantTrueEvaluator.NAME;
            }
        }
    }

    private record ConstantFalseEvaluator(DriverContext context) implements ExpressionEvaluator
    {
        private static final String NAME = "ConstantFalse";
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(ConstantFalseEvaluator.class);

        @Override
        public Block eval(Page page) {
            return this.context.blockFactory().newConstantBooleanBlockWith(false, page.getPositionCount());
        }

        public void close() {
        }

        @Override
        public String toString() {
            return NAME;
        }

        @Override
        public long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        record Factory() implements ExpressionEvaluator.Factory
        {
            @Override
            public ConstantFalseEvaluator get(DriverContext context) {
                return new ConstantFalseEvaluator(context);
            }

            @Override
            public String toString() {
                return ConstantFalseEvaluator.NAME;
            }
        }
    }

    public record EvalOperatorFactory(ExpressionEvaluator.Factory evaluator) implements Operator.OperatorFactory
    {
        @Override
        public Operator get(DriverContext driverContext) {
            return new EvalOperator(driverContext, this.evaluator.get(driverContext));
        }

        @Override
        public String describe() {
            return "EvalOperator[evaluator=" + String.valueOf(this.evaluator) + "]";
        }
    }
}

