/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BinarySearcher;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.sort.SortOrder;

public class LongTopNSet
implements Releasable {
    private final SortOrder order;
    private int limit;
    private final LongArray values;
    private final LongBinarySearcher searcher;
    private int count;

    public LongTopNSet(BigArrays bigArrays, SortOrder order, int limit) {
        this.order = order;
        this.limit = limit;
        this.count = 0;
        this.values = bigArrays.newLongArray((long)limit, false);
        this.searcher = new LongBinarySearcher(this.values, order);
    }

    public boolean collect(long value) {
        if (this.limit == 0) {
            return false;
        }
        if (this.count == this.limit && this.betterThan(this.getWorstValue(), value)) {
            return false;
        }
        if (this.count == 0) {
            this.values.set(0L, value);
            ++this.count;
            return true;
        }
        int insertionIndex = this.searcher.search(0, this.count - 1, value);
        if (insertionIndex == this.count - 1 && this.betterThan(this.getWorstValue(), value)) {
            this.values.set((long)this.count, value);
            ++this.count;
            return true;
        }
        if (this.values.get((long)insertionIndex) == value) {
            return true;
        }
        for (int i = Math.min(this.count, this.limit - 1); i > insertionIndex; --i) {
            this.values.set((long)i, this.values.get((long)(i - 1)));
        }
        this.values.set((long)insertionIndex, value);
        this.count = Math.min(this.count + 1, this.limit);
        return true;
    }

    public void reduceLimitByOne() {
        --this.limit;
        this.count = Math.min(this.count, this.limit);
    }

    public long getWorstValue() {
        assert (this.count > 0);
        return this.values.get((long)(this.count - 1));
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getCount() {
        return this.count;
    }

    private boolean betterThan(long lhs, long rhs) {
        return this.getOrder().reverseMul() * Long.compare(lhs, rhs) < 0;
    }

    public final void close() {
        Releasables.close((Releasable)this.values);
    }

    private static class LongBinarySearcher
    extends BinarySearcher {
        final LongArray array;
        final SortOrder order;
        long searchFor;

        LongBinarySearcher(LongArray array, SortOrder order) {
            this.array = array;
            this.order = order;
            this.searchFor = Integer.MIN_VALUE;
        }

        protected int compare(int index) {
            assert (this.searchFor != Integer.MIN_VALUE);
            return this.order.reverseMul() * Long.compare(this.array.get((long)index), this.searchFor);
        }

        protected int getClosestIndex(int index1, int index2) {
            return Math.max(index1, index2);
        }

        protected double distance(int index) {
            throw new UnsupportedOperationException("getClosestIndex() is overridden and doesn't depend on this");
        }

        public int search(int from, int to, long searchFor) {
            this.searchFor = searchFor;
            return super.search(from, to);
        }
    }
}

