/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.data.sort;

import java.util.stream.IntStream;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.ByteArray;
import org.elasticsearch.common.util.ByteUtils;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.sort.BucketedSortCommon;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.sort.SortOrder;

public class IpBucketedSort
implements Releasable {
    private static final int IP_LENGTH = 16;
    private final BytesRef scratch1 = new BytesRef();
    private final BytesRef scratch2 = new BytesRef();
    private final byte[] scratchBytes = new byte[16];
    private final BucketedSortCommon common;
    private ByteArray values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpBucketedSort(BigArrays bigArrays, SortOrder order, int bucketSize) {
        this.common = new BucketedSortCommon(bigArrays, order, bucketSize);
        boolean success = false;
        try {
            this.values = bigArrays.newByteArray(0L, false);
            success = true;
        }
        finally {
            if (!success) {
                this.close();
            }
        }
    }

    public void collect(BytesRef value, int bucket) {
        assert (value.length == 16);
        long rootIndex = this.common.rootIndex(bucket);
        if (this.common.inHeapMode(bucket)) {
            if (this.betterThan(value, this.get(rootIndex, this.scratch1))) {
                this.set(rootIndex, value);
                this.downHeap(rootIndex, 0, this.common.bucketSize);
            }
            return;
        }
        long requiredSize = this.common.endIndex(rootIndex) * 16L;
        if (this.values.size() < requiredSize) {
            this.grow(bucket);
        }
        int next = this.getNextGatherOffset(rootIndex);
        this.common.assertValidNextOffset(next);
        long index = (long)next + rootIndex;
        this.set(index, value);
        if (next == 0) {
            this.common.enableHeapMode(bucket);
            this.heapify(rootIndex, this.common.bucketSize);
        } else {
            this.setNextGatherOffset(rootIndex, next - 1);
        }
    }

    private Tuple<Long, Long> getBucketValuesIndexes(int bucket) {
        long rootIndex = this.common.rootIndex(bucket);
        if (rootIndex >= this.values.size() / 16L) {
            return Tuple.tuple((Object)0L, (Object)0L);
        }
        long start = this.startIndex(bucket, rootIndex);
        long end = this.common.endIndex(rootIndex);
        return Tuple.tuple((Object)start, (Object)end);
    }

    public void merge(int groupId, IpBucketedSort other, int otherGroupId) {
        Tuple<Long, Long> otherBounds = other.getBucketValuesIndexes(otherGroupId);
        BytesRef scratch = new BytesRef();
        for (long i = ((Long)otherBounds.v1()).longValue(); i < (Long)otherBounds.v2(); ++i) {
            this.collect(other.get(i, scratch), groupId);
        }
    }

    public Block toBlock(BlockFactory blockFactory, IntVector selected) {
        if (IntStream.range(0, selected.getPositionCount()).map(selected::getInt).noneMatch(bucket -> {
            Tuple<Long, Long> bounds = this.getBucketValuesIndexes(bucket);
            long size = (Long)bounds.v2() - (Long)bounds.v1();
            return size > 0L;
        })) {
            return blockFactory.newConstantNullBlock(selected.getPositionCount());
        }
        try (BytesRefBlock.Builder builder = blockFactory.newBytesRefBlockBuilder(selected.getPositionCount());){
            for (int s = 0; s < selected.getPositionCount(); ++s) {
                int bucket2 = selected.getInt(s);
                Tuple<Long, Long> bounds = this.getBucketValuesIndexes(bucket2);
                Long rootIndex = (Long)bounds.v1();
                long size = (Long)bounds.v2() - (Long)bounds.v1();
                if (size == 0L) {
                    builder.appendNull();
                    continue;
                }
                if (size == 1L) {
                    builder.appendBytesRef(this.get(rootIndex, this.scratch1));
                    continue;
                }
                if (!this.common.inHeapMode(bucket2)) {
                    this.heapify(rootIndex, (int)size);
                }
                this.heapSort(rootIndex, (int)size);
                builder.beginPositionEntry();
                int i = 0;
                while ((long)i < size) {
                    builder.appendBytesRef(this.get(rootIndex + (long)i, new BytesRef()));
                    ++i;
                }
                builder.endPositionEntry();
            }
            BytesRefBlock bytesRefBlock = builder.build();
            return bytesRefBlock;
        }
    }

    private long startIndex(int bucket, long rootIndex) {
        if (this.common.inHeapMode(bucket)) {
            return rootIndex;
        }
        return rootIndex + (long)this.getNextGatherOffset(rootIndex) + 1L;
    }

    private int getNextGatherOffset(long rootIndex) {
        this.values.get(rootIndex * 16L, 4, this.scratch1);
        assert (this.scratch1.length == 4);
        return ByteUtils.readIntLE((byte[])this.scratch1.bytes, (int)this.scratch1.offset);
    }

    private void setNextGatherOffset(long rootIndex, int offset) {
        this.scratch1.bytes = this.scratchBytes;
        this.scratch1.offset = 0;
        this.scratch1.length = 4;
        ByteUtils.writeIntLE((int)offset, (byte[])this.scratch1.bytes, (int)this.scratch1.offset);
        this.values.set(rootIndex * 16L, this.scratch1.bytes, this.scratch1.offset, this.scratch1.length);
    }

    private boolean betterThan(BytesRef lhs, BytesRef rhs) {
        return this.common.order.reverseMul() * lhs.compareTo(rhs) < 0;
    }

    private void swap(long lhs, long rhs) {
        this.values.get(lhs * 16L, 16, this.scratch1);
        assert (this.scratch1.length == 16);
        System.arraycopy(this.scratch1.bytes, this.scratch1.offset, this.scratchBytes, 0, this.scratch1.length);
        this.values.get(rhs * 16L, 16, this.scratch2);
        assert (this.scratch2.length == 16);
        this.values.set(lhs * 16L, this.scratch2.bytes, this.scratch2.offset, this.scratch2.length);
        this.scratch1.bytes = this.scratchBytes;
        this.scratch1.offset = 0;
        this.values.set(rhs * 16L, this.scratch1.bytes, this.scratch1.offset, this.scratch1.length);
    }

    private void grow(int bucket) {
        long oldMax = this.values.size() / 16L;
        assert (oldMax % (long)this.common.bucketSize == 0L);
        int bucketBytes = this.common.bucketSize * 16;
        long newSize = BigArrays.overSize((long)(((long)bucket + 1L) * (long)bucketBytes), (int)16384, (int)1);
        newSize = (newSize + (long)bucketBytes - 1L) / (long)bucketBytes;
        this.values = this.common.bigArrays.resize(this.values, newSize * (long)bucketBytes);
        this.fillGatherOffsets(oldMax);
    }

    private void fillGatherOffsets(long startingAt) {
        int nextOffset = this.common.bucketSize - 1;
        for (long bucketRoot = startingAt; bucketRoot < this.values.size() / 16L; bucketRoot += (long)this.common.bucketSize) {
            this.setNextGatherOffset(bucketRoot, nextOffset);
        }
    }

    private void heapify(long rootIndex, int heapSize) {
        int maxParent;
        for (int parent = maxParent = heapSize / 2 - 1; parent >= 0; --parent) {
            this.downHeap(rootIndex, parent, heapSize);
        }
    }

    private void heapSort(long rootIndex, int heapSize) {
        while (heapSize > 0) {
            this.swap(rootIndex, rootIndex + (long)heapSize - 1L);
            this.downHeap(rootIndex, 0, --heapSize);
        }
    }

    private void downHeap(long rootIndex, int parent, int heapSize) {
        while (true) {
            long parentIndex = rootIndex + (long)parent;
            int worst = parent;
            long worstIndex = parentIndex;
            int leftChild = parent * 2 + 1;
            long leftIndex = rootIndex + (long)leftChild;
            if (leftChild < heapSize) {
                if (this.betterThan(this.get(worstIndex, this.scratch1), this.get(leftIndex, this.scratch2))) {
                    worst = leftChild;
                    worstIndex = leftIndex;
                }
                int rightChild = leftChild + 1;
                long rightIndex = rootIndex + (long)rightChild;
                if (rightChild < heapSize && this.betterThan(this.get(worstIndex, this.scratch1), this.get(rightIndex, this.scratch2))) {
                    worst = rightChild;
                    worstIndex = rightIndex;
                }
            }
            if (worst == parent) break;
            this.swap(worstIndex, parentIndex);
            parent = worst;
        }
    }

    private BytesRef get(long index, BytesRef scratch) {
        this.values.get(index * 16L, 16, scratch);
        assert (scratch.length == 16);
        return scratch;
    }

    private void set(long index, BytesRef value) {
        assert (value.length == 16);
        this.values.set(index * 16L, value.bytes, value.offset, value.length);
    }

    public final void close() {
        Releasables.close((Releasable[])new Releasable[]{this.values, this.common});
    }
}

