/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation.blockhash;

import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.BitArray;
import org.elasticsearch.common.util.LongLongHash;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.aggregation.blockhash.BlockHash;
import org.elasticsearch.compute.aggregation.blockhash.BytesRefBlockHash;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.BytesRefBlock;
import org.elasticsearch.compute.data.BytesRefVector;
import org.elasticsearch.compute.data.IntBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.mvdedupe.IntLongBlockAdd;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.ReleasableIterator;
import org.elasticsearch.core.Releasables;

final class BytesRefLongBlockHash
extends BlockHash {
    private final int bytesChannel;
    private final int longsChannel;
    private final boolean reverseOutput;
    private final int emitBatchSize;
    private final BytesRefBlockHash bytesHash;
    private final LongLongHash finalHash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BytesRefLongBlockHash(BlockFactory blockFactory, int bytesChannel, int longsChannel, boolean reverseOutput, int emitBatchSize) {
        super(blockFactory);
        this.bytesChannel = bytesChannel;
        this.longsChannel = longsChannel;
        this.reverseOutput = reverseOutput;
        this.emitBatchSize = emitBatchSize;
        boolean success = false;
        BytesRefBlockHash bytesHash = null;
        try {
            this.bytesHash = bytesHash = new BytesRefBlockHash(bytesChannel, blockFactory);
            this.finalHash = new LongLongHash(1L, blockFactory.bigArrays());
            success = true;
        }
        finally {
            if (!success) {
                Releasables.close((Releasable)bytesHash);
            }
        }
    }

    public void close() {
        Releasables.close((Releasable[])new Releasable[]{this.bytesHash, this.finalHash});
    }

    @Override
    public void add(Page page, GroupingAggregatorFunction.AddInput addInput) {
        BytesRefBlock bytesBlock = (BytesRefBlock)page.getBlock(this.bytesChannel);
        BytesRefVector bytesVector = bytesBlock.asVector();
        if (bytesVector != null) {
            try (IntVector bytesHashes = this.bytesHash.add(bytesVector);){
                this.add(page, bytesHashes, addInput);
            }
        }
        try (IntBlock bytesHashes = this.bytesHash.add(bytesBlock);){
            this.add(bytesHashes, (LongBlock)page.getBlock(this.longsChannel), addInput);
        }
    }

    public void add(Page page, IntVector bytesHashes, GroupingAggregatorFunction.AddInput addInput) {
        LongBlock longsBlock = (LongBlock)page.getBlock(this.longsChannel);
        LongVector longsVector = longsBlock.asVector();
        if (longsVector != null) {
            try (IntVector ords = this.add(bytesHashes, longsVector);){
                addInput.add(0, ords);
            }
        } else {
            this.add(bytesHashes.asBlock(), longsBlock, addInput);
        }
    }

    public void add(IntBlock bytesHashes, LongBlock longsBlock, GroupingAggregatorFunction.AddInput addInput) {
        try (IntLongBlockAdd work = new IntLongBlockAdd(this.blockFactory, this.emitBatchSize, addInput, this.finalHash, bytesHashes, longsBlock);){
            work.add();
        }
    }

    public IntVector add(IntVector bytesHashes, LongVector longsVector) {
        int positions = bytesHashes.getPositionCount();
        int[] ords = new int[positions];
        int lastByte = bytesHashes.getInt(0);
        long lastLong = longsVector.getLong(0);
        ords[0] = Math.toIntExact(BytesRefLongBlockHash.hashOrdToGroup(this.finalHash.add((long)lastByte, lastLong)));
        boolean constant = true;
        if (bytesHashes.isConstant()) {
            for (int i = 1; i < positions; ++i) {
                long nextLong = longsVector.getLong(i);
                if (nextLong == lastLong) {
                    ords[i] = ords[i - 1];
                    continue;
                }
                ords[i] = Math.toIntExact(BytesRefLongBlockHash.hashOrdToGroup(this.finalHash.add((long)lastByte, nextLong)));
                lastLong = nextLong;
                constant = false;
            }
        } else {
            for (int i = 1; i < positions; ++i) {
                int nextByte = bytesHashes.getInt(i);
                long nextLong = longsVector.getLong(i);
                if (nextByte == lastByte && nextLong == lastLong) {
                    ords[i] = ords[i - 1];
                    continue;
                }
                ords[i] = Math.toIntExact(BytesRefLongBlockHash.hashOrdToGroup(this.finalHash.add((long)nextByte, nextLong)));
                lastByte = nextByte;
                lastLong = nextLong;
                constant = false;
            }
        }
        if (constant) {
            return this.blockFactory.newConstantIntVector(ords[0], positions);
        }
        return this.blockFactory.newIntArrayVector(ords, positions);
    }

    @Override
    public ReleasableIterator<IntBlock> lookup(Page page, ByteSizeValue targetBlockSize) {
        throw new UnsupportedOperationException("TODO");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Block[] getKeys() {
        LongVector k2;
        BytesRefBlock k1;
        block19: {
            int positions = (int)this.finalHash.size();
            k1 = null;
            k2 = null;
            try {
                try (BytesRefBlock.Builder keys1 = this.blockFactory.newBytesRefBlockBuilder(positions);
                     LongVector.Builder keys2 = this.blockFactory.newLongVectorBuilder(positions);){
                    BytesRef scratch = new BytesRef();
                    for (long i = 0L; i < (long)positions; ++i) {
                        keys2.appendLong(this.finalHash.getKey2(i));
                        long h1 = this.finalHash.getKey1(i);
                        if (h1 == 0L) {
                            keys1.appendNull();
                            continue;
                        }
                        keys1.appendBytesRef(this.bytesHash.hash.get(h1 - 1L, scratch));
                    }
                    k1 = keys1.build();
                    k2 = keys2.build();
                }
                if (k2 != null) break block19;
            }
            catch (Throwable throwable) {
                if (k2 == null) {
                    Releasables.closeExpectNoException(k1);
                }
                throw throwable;
            }
            Releasables.closeExpectNoException((Releasable)k1);
        }
        if (this.reverseOutput) {
            return new Block[]{k2.asBlock(), k1};
        }
        return new Block[]{k1, k2.asBlock()};
    }

    @Override
    public BitArray seenGroupIds(BigArrays bigArrays) {
        return new SeenGroupIds.Range(0, Math.toIntExact(this.finalHash.size())).seenGroupIds(bigArrays);
    }

    @Override
    public IntVector nonEmpty() {
        return IntVector.range(0, Math.toIntExact(this.finalHash.size()), this.blockFactory);
    }

    public String toString() {
        return "BytesRefLongBlockHash{keys=[BytesRefKey[channel=" + this.bytesChannel + "], LongKey[channel=" + this.longsChannel + "]], entries=" + this.finalHash.size() + ", size=" + this.bytesHash.hash.ramBytesUsed() + "b}";
    }
}

