/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.DeltaDoubleAggregator;
import org.elasticsearch.compute.aggregation.GroupingAggregatorEvaluationContext;
import org.elasticsearch.compute.aggregation.GroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.SeenGroupIds;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.IntArrayBlock;
import org.elasticsearch.compute.data.IntBigArrayBlock;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class DeltaDoubleGroupingAggregatorFunction
implements GroupingAggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("samples", ElementType.LONG), new IntermediateStateDesc("timestamps", ElementType.LONG), new IntermediateStateDesc("values", ElementType.DOUBLE));
    private final DeltaDoubleAggregator.DoubleDeltaGroupingState state;
    private final List<Integer> channels;
    private final DriverContext driverContext;

    public DeltaDoubleGroupingAggregatorFunction(List<Integer> channels, DeltaDoubleAggregator.DoubleDeltaGroupingState state, DriverContext driverContext) {
        this.channels = channels;
        this.state = state;
        this.driverContext = driverContext;
    }

    public static DeltaDoubleGroupingAggregatorFunction create(List<Integer> channels, DriverContext driverContext) {
        return new DeltaDoubleGroupingAggregatorFunction(channels, DeltaDoubleAggregator.initGrouping(driverContext), driverContext);
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public GroupingAggregatorFunction.AddInput prepareProcessRawInputPage(SeenGroupIds seenGroupIds, Page page) {
        final DoubleBlock valueBlock = (DoubleBlock)page.getBlock(this.channels.get(0));
        final LongBlock timestampBlock = (LongBlock)page.getBlock(this.channels.get(1));
        final DoubleVector valueVector = valueBlock.asVector();
        if (valueVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock, timestampBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                public void close() {
                }
            };
        }
        final LongVector timestampVector = timestampBlock.asVector();
        if (timestampVector == null) {
            this.maybeEnableGroupIdTracking(seenGroupIds, valueBlock, timestampBlock);
            return new GroupingAggregatorFunction.AddInput(){

                @Override
                public void add(int positionOffset, IntArrayBlock groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntBigArrayBlock groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                @Override
                public void add(int positionOffset, IntVector groupIds) {
                    DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueBlock, timestampBlock);
                }

                public void close() {
                }
            };
        }
        return new GroupingAggregatorFunction.AddInput(){

            @Override
            public void add(int positionOffset, IntArrayBlock groupIds) {
                DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            @Override
            public void add(int positionOffset, IntBigArrayBlock groupIds) {
                DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            @Override
            public void add(int positionOffset, IntVector groupIds) {
                DeltaDoubleGroupingAggregatorFunction.this.addRawInput(positionOffset, groupIds, valueVector, timestampVector);
            }

            public void close() {
            }
        };
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, DoubleBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset) || timestampBlock.isNull(valuesPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    double valueValue = valueBlock.getDouble(valueOffset);
                    int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                    int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                    for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                        long timestampValue = timestampBlock.getLong(timestampOffset);
                        DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
                    }
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntArrayBlock groups, DoubleVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                double valueValue = valueVector.getDouble(valuesPosition);
                long timestampValue = timestampVector.getLong(valuesPosition);
                DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock values = (DoubleBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                DeltaDoubleAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, DoubleBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition;
            if (groups.isNull(groupPosition) || valueBlock.isNull(valuesPosition = groupPosition + positionOffset) || timestampBlock.isNull(valuesPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
                int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
                for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                    double valueValue = valueBlock.getDouble(valueOffset);
                    int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                    int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                    for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                        long timestampValue = timestampBlock.getLong(timestampOffset);
                        DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
                    }
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntBigArrayBlock groups, DoubleVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int valuesPosition = groupPosition + positionOffset;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                double valueValue = valueVector.getDouble(valuesPosition);
                long timestampValue = timestampVector.getLong(valuesPosition);
                DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
            }
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntBigArrayBlock groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock values = (DoubleBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            if (groups.isNull(groupPosition)) continue;
            int groupStart = groups.getFirstValueIndex(groupPosition);
            int groupEnd = groupStart + groups.getValueCount(groupPosition);
            for (int g = groupStart; g < groupEnd; ++g) {
                int groupId = groups.getInt(g);
                int valuesPosition = groupPosition + positionOffset;
                DeltaDoubleAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleBlock valueBlock, LongBlock timestampBlock) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            if (valueBlock.isNull(valuesPosition) || timestampBlock.isNull(valuesPosition)) continue;
            int groupId = groups.getInt(groupPosition);
            int valueStart = valueBlock.getFirstValueIndex(valuesPosition);
            int valueEnd = valueStart + valueBlock.getValueCount(valuesPosition);
            for (int valueOffset = valueStart; valueOffset < valueEnd; ++valueOffset) {
                double valueValue = valueBlock.getDouble(valueOffset);
                int timestampStart = timestampBlock.getFirstValueIndex(valuesPosition);
                int timestampEnd = timestampStart + timestampBlock.getValueCount(valuesPosition);
                for (int timestampOffset = timestampStart; timestampOffset < timestampEnd; ++timestampOffset) {
                    long timestampValue = timestampBlock.getLong(timestampOffset);
                    DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
                }
            }
        }
    }

    private void addRawInput(int positionOffset, IntVector groups, DoubleVector valueVector, LongVector timestampVector) {
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int valuesPosition = groupPosition + positionOffset;
            int groupId = groups.getInt(groupPosition);
            double valueValue = valueVector.getDouble(valuesPosition);
            long timestampValue = timestampVector.getLong(valuesPosition);
            DeltaDoubleAggregator.combine(this.state, groupId, valueValue, timestampValue);
        }
    }

    @Override
    public void addIntermediateInput(int positionOffset, IntVector groups, Page page) {
        this.state.enableGroupIdTracking(new SeenGroupIds.Empty());
        assert (this.channels.size() == this.intermediateBlockCount());
        Object samplesUncast = page.getBlock(this.channels.get(0));
        if (samplesUncast.areAllValuesNull()) {
            return;
        }
        LongBlock samples = (LongBlock)samplesUncast;
        Object timestampsUncast = page.getBlock(this.channels.get(1));
        if (timestampsUncast.areAllValuesNull()) {
            return;
        }
        LongBlock timestamps = (LongBlock)timestampsUncast;
        Object valuesUncast = page.getBlock(this.channels.get(2));
        if (valuesUncast.areAllValuesNull()) {
            return;
        }
        DoubleBlock values = (DoubleBlock)valuesUncast;
        assert (samples.getPositionCount() == timestamps.getPositionCount() && samples.getPositionCount() == values.getPositionCount());
        for (int groupPosition = 0; groupPosition < groups.getPositionCount(); ++groupPosition) {
            int groupId = groups.getInt(groupPosition);
            int valuesPosition = groupPosition + positionOffset;
            DeltaDoubleAggregator.combineIntermediate(this.state, groupId, samples, timestamps, values, valuesPosition);
        }
    }

    private void maybeEnableGroupIdTracking(SeenGroupIds seenGroupIds, DoubleBlock valueBlock, LongBlock timestampBlock) {
        if (valueBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
        if (timestampBlock.mayHaveNulls()) {
            this.state.enableGroupIdTracking(seenGroupIds);
        }
    }

    @Override
    public void selectedMayContainUnseenGroups(SeenGroupIds seenGroupIds) {
        this.state.enableGroupIdTracking(seenGroupIds);
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, IntVector selected) {
        this.state.toIntermediate(blocks, offset, selected, this.driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, IntVector selected, GroupingAggregatorEvaluationContext ctx) {
        blocks[offset] = DeltaDoubleAggregator.evaluateFinal(this.state, selected, ctx);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

