/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

public class CagraSearchParams {
    private int maxQueries;
    private int iTopKSize;
    private int maxIterations;
    private int teamSize;
    private int searchWidth;
    private int minIterations;
    private int threadBlockSize;
    private int hashmapMinBitlen;
    private int numRandomSamplings;
    private float hashMapMaxFillRate;
    private long randXORMask;
    private SearchAlgo searchAlgo;
    private HashMapMode hashMapMode;

    private CagraSearchParams(int maxQueries, int iTopKSize, int maxIterations, SearchAlgo searchAlgo, int teamSize, int searchWidth, int minIterations, int threadBlockSize, HashMapMode hashmapMode, int hashmapMinBitlen, float hashmapMaxFillRate, int numRandomSamplings, long randXORMask) {
        this.maxQueries = maxQueries;
        this.iTopKSize = iTopKSize;
        this.maxIterations = maxIterations;
        this.searchAlgo = searchAlgo;
        this.teamSize = teamSize;
        this.searchWidth = searchWidth;
        this.minIterations = minIterations;
        this.threadBlockSize = threadBlockSize;
        this.hashMapMode = hashmapMode;
        this.hashmapMinBitlen = hashmapMinBitlen;
        this.hashMapMaxFillRate = hashmapMaxFillRate;
        this.numRandomSamplings = numRandomSamplings;
        this.randXORMask = randXORMask;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    public int getITopKSize() {
        return this.iTopKSize;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getTeamSize() {
        return this.teamSize;
    }

    public int getSearchWidth() {
        return this.searchWidth;
    }

    public int getMinIterations() {
        return this.minIterations;
    }

    public int getThreadBlockSize() {
        return this.threadBlockSize;
    }

    public int getHashmapMinBitlen() {
        return this.hashmapMinBitlen;
    }

    public int getNumRandomSamplings() {
        return this.numRandomSamplings;
    }

    public float getHashMapMaxFillRate() {
        return this.hashMapMaxFillRate;
    }

    public long getRandXORMask() {
        return this.randXORMask;
    }

    public SearchAlgo getCagraSearchAlgo() {
        return this.searchAlgo;
    }

    public HashMapMode getHashMapMode() {
        return this.hashMapMode;
    }

    public String toString() {
        return "CagraSearchParams [maxQueries=" + this.maxQueries + ", itopkSize=" + this.iTopKSize + ", maxIterations=" + this.maxIterations + ", cuvsCagraSearchAlgo=" + String.valueOf((Object)this.searchAlgo) + ", teamSize=" + this.teamSize + ", searchWidth=" + this.searchWidth + ", minIterations=" + this.minIterations + ", threadBlockSize=" + this.threadBlockSize + ", hashMapMode=" + String.valueOf((Object)this.hashMapMode) + ", hashMapMinBitlen=" + this.hashmapMinBitlen + ", hashMapMaxFillRate=" + this.hashMapMaxFillRate + ", numRandomSamplings=" + this.numRandomSamplings + ", randXORMask=" + this.randXORMask + "]";
    }

    public static enum SearchAlgo {
        SINGLE_CTA(0),
        MULTI_CTA(1),
        MULTI_KERNEL(2),
        AUTO(3);

        public final int value;

        private SearchAlgo(int value) {
            this.value = value;
        }
    }

    public static enum HashMapMode {
        HASH(0),
        SMALL(1),
        AUTO_HASH(2);

        public final int value;

        private HashMapMode(int value) {
            this.value = value;
        }
    }

    public static class Builder {
        private int maxQueries;
        private int iTopKSize = 64;
        private int maxIterations;
        private int teamSize;
        private int searchWidth = 1;
        private int minIterations;
        private int threadBlockSize;
        private int hashMapMinBitlen;
        private int numRandomSamplings = 1;
        private float hashMapMaxFillRate = 0.5f;
        private long randXORMask = 1213332L;
        private SearchAlgo searchAlgo;
        private HashMapMode hashMapMode;

        public Builder withMaxQueries(int maxQueries) {
            this.maxQueries = maxQueries;
            return this;
        }

        public Builder withItopkSize(int iTopKSize) {
            this.iTopKSize = iTopKSize;
            return this;
        }

        public Builder withMaxIterations(int maxIterations) {
            this.maxIterations = maxIterations;
            return this;
        }

        public Builder withAlgo(SearchAlgo cuvsCagraSearchAlgo) {
            this.searchAlgo = cuvsCagraSearchAlgo;
            return this;
        }

        public Builder withTeamSize(int teamSize) {
            this.teamSize = teamSize;
            return this;
        }

        public Builder withSearchWidth(int searchWidth) {
            this.searchWidth = searchWidth;
            return this;
        }

        public Builder withMinIterations(int minIterations) {
            this.minIterations = minIterations;
            return this;
        }

        public Builder withThreadBlockSize(int threadBlockSize) {
            this.threadBlockSize = threadBlockSize;
            return this;
        }

        public Builder withHashMapMode(HashMapMode hashMapMode) {
            this.hashMapMode = hashMapMode;
            return this;
        }

        public Builder withHashMapMinBitlen(int hashMapMinBitlen) {
            this.hashMapMinBitlen = hashMapMinBitlen;
            return this;
        }

        public Builder withHashMapMaxFillRate(float hashMapMaxFillRate) {
            this.hashMapMaxFillRate = hashMapMaxFillRate;
            return this;
        }

        public Builder withNumRandomSamplings(int numRandomSamplings) {
            this.numRandomSamplings = numRandomSamplings;
            return this;
        }

        public Builder withRandXorMask(long randXORMask) {
            this.randXORMask = randXORMask;
            return this;
        }

        public CagraSearchParams build() {
            return new CagraSearchParams(this.maxQueries, this.iTopKSize, this.maxIterations, this.searchAlgo, this.teamSize, this.searchWidth, this.minIterations, this.threadBlockSize, this.hashMapMode, this.hashMapMinBitlen, this.hashMapMaxFillRate, this.numRandomSamplings, this.randXORMask);
        }
    }
}

