/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CagraSearchParams;
import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.SearchResults;
import java.util.BitSet;
import java.util.Objects;
import java.util.function.LongToIntFunction;

public class CagraQuery {
    private final CagraSearchParams cagraSearchParameters;
    private final LongToIntFunction mapping;
    private final CuVSMatrix queryVectors;
    private final int topK;
    private final BitSet prefilter;
    private final int numDocs;
    private final CuVSResources resources;

    private CagraQuery(CagraSearchParams cagraSearchParameters, CuVSMatrix queryVectors, LongToIntFunction mapping, int topK, BitSet prefilter, int numDocs, CuVSResources resources) {
        this.cagraSearchParameters = cagraSearchParameters;
        this.queryVectors = queryVectors;
        this.mapping = mapping;
        this.topK = topK;
        this.prefilter = prefilter;
        this.numDocs = numDocs;
        this.resources = resources;
    }

    public CagraSearchParams getCagraSearchParameters() {
        return this.cagraSearchParameters;
    }

    public CuVSMatrix getQueryVectors() {
        return this.queryVectors;
    }

    public LongToIntFunction getMapping() {
        return this.mapping;
    }

    public int getTopK() {
        return this.topK;
    }

    public BitSet getPrefilter() {
        return this.prefilter;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public CuVSResources getResources() {
        return this.resources;
    }

    public String toString() {
        return "CuVSQuery [cagraSearchParameters=" + String.valueOf(this.cagraSearchParameters) + ", queryVectors=" + this.queryVectors.toString() + ", mapping=" + String.valueOf(this.mapping) + ", topK=" + this.topK + "]";
    }

    public static class Builder {
        private CagraSearchParams cagraSearchParams;
        private CuVSMatrix queryVectors;
        private LongToIntFunction mapping = SearchResults.IDENTITY_MAPPING;
        private int topK = 2;
        private BitSet prefilter;
        private int numDocs;
        private final CuVSResources resources;

        public Builder(CuVSResources resources) {
            this.resources = Objects.requireNonNull(resources, "resources cannot be null");
        }

        public Builder withSearchParams(CagraSearchParams cagraSearchParams) {
            this.cagraSearchParams = cagraSearchParams;
            return this;
        }

        public Builder withQueryVectors(CuVSMatrix queryVectors) {
            this.queryVectors = queryVectors;
            return this;
        }

        public Builder withMapping(LongToIntFunction mapping) {
            this.mapping = mapping;
            return this;
        }

        public Builder withTopK(int topK) {
            this.topK = topK;
            return this;
        }

        public Builder withPrefilter(BitSet prefilter, int numDocs) {
            this.prefilter = prefilter;
            this.numDocs = numDocs;
            return this;
        }

        public CagraQuery build() {
            return new CagraQuery(this.cagraSearchParams, this.queryVectors, this.mapping, this.topK, this.prefilter, this.numDocs, this.resources);
        }
    }
}

