/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs.internal;

import com.nvidia.cuvs.CuVSMatrix;
import com.nvidia.cuvs.RowView;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.Locale;

class SliceRowView
implements RowView {
    private final MemorySegment memorySegment;
    private final long size;
    private final ValueLayout valueLayout;
    private final CuVSMatrix.DataType dataType;
    private final long valueByteSize;

    SliceRowView(MemorySegment slice, long size, ValueLayout valueLayout, CuVSMatrix.DataType dataType, long valueByteSize) {
        this.memorySegment = slice;
        this.size = size;
        this.valueLayout = valueLayout;
        this.dataType = dataType;
        this.valueByteSize = valueByteSize;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public float getAsFloat(long index) {
        assert (index < this.size) : String.format(Locale.ROOT, "Index out of bound ([%d], size [%d])", index, this.size);
        assert (this.dataType == CuVSMatrix.DataType.FLOAT) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        return this.memorySegment.get((ValueLayout.OfFloat)this.valueLayout, index * this.valueByteSize);
    }

    @Override
    public byte getAsByte(long index) {
        assert (index < this.size) : String.format(Locale.ROOT, "Index out of bound ([%d], size [%d])", index, this.size);
        assert (this.dataType == CuVSMatrix.DataType.BYTE) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        return this.memorySegment.get((ValueLayout.OfByte)this.valueLayout, index * this.valueByteSize);
    }

    @Override
    public int getAsInt(long index) {
        assert (index < this.size) : String.format(Locale.ROOT, "Index out of bound ([%d], size [%d])", index, this.size);
        assert (this.dataType == CuVSMatrix.DataType.INT || this.dataType == CuVSMatrix.DataType.UINT) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        return this.memorySegment.get((ValueLayout.OfInt)this.valueLayout, index * this.valueByteSize);
    }

    @Override
    public void toArray(int[] array) {
        assert ((long)array.length >= this.size) : String.format(Locale.ROOT, "Input array is not large enough (required: [%d], actual [%d])", this.size, array.length);
        assert (this.dataType == CuVSMatrix.DataType.INT || this.dataType == CuVSMatrix.DataType.UINT) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        MemorySegment.copy(this.memorySegment, this.valueLayout, 0L, array, 0, (int)this.size);
    }

    @Override
    public void toArray(float[] array) {
        assert ((long)array.length >= this.size) : String.format(Locale.ROOT, "Input array is not large enough (required: [%d], actual [%d])", this.size, array.length);
        assert (this.dataType == CuVSMatrix.DataType.FLOAT) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        MemorySegment.copy(this.memorySegment, this.valueLayout, 0L, array, 0, (int)this.size);
    }

    @Override
    public void toArray(byte[] array) {
        assert ((long)array.length >= this.size) : String.format(Locale.ROOT, "Input array is not large enough (required: [%d], actual [%d])", this.size, array.length);
        assert (this.dataType == CuVSMatrix.DataType.BYTE) : String.format(Locale.ROOT, "Input array is of the wrong type for dataType [%s]", this.dataType.toString());
        MemorySegment.copy(this.memorySegment, this.valueLayout, 0L, array, 0, (int)this.size);
    }
}

