/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.plan.logical;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.esql.analysis.Analyzer;
import org.elasticsearch.xpack.esql.capabilities.PostAnalysisPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.TelemetryAware;
import org.elasticsearch.xpack.esql.common.Failure;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.NamedExpression;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.ExecutesOn;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public class Fork
extends LogicalPlan
implements PostAnalysisPlanVerificationAware,
TelemetryAware,
ExecutesOn.Coordinator {
    public static final String FORK_FIELD = "_fork";
    public static final int MAX_BRANCHES = 8;
    public static final int MIN_BRANCHES = 2;
    private final List<Attribute> output;

    public Fork(Source source, List<LogicalPlan> children, List<Attribute> output) {
        super(source, children);
        if (children.size() < 2) {
            throw new IllegalArgumentException("FORK requires more than 2 branches, got: " + children.size());
        }
        if (children.size() > 8) {
            throw new IllegalArgumentException("FORK supports up to 8 branches, got: " + children.size());
        }
        this.output = output;
    }

    public LogicalPlan replaceChildren(List<LogicalPlan> newChildren) {
        return new Fork(this.source(), newChildren, this.output);
    }

    public void writeTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException("not serialized");
    }

    public String getWriteableName() {
        throw new UnsupportedOperationException("not serialized");
    }

    @Override
    public boolean expressionsResolved() {
        if (!this.children().stream().allMatch(LogicalPlan::resolved)) {
            return false;
        }
        if (this.children().stream().anyMatch(p -> p.outputSet().names().contains("<no-fields>") || this.output.size() != p.output().size())) {
            return false;
        }
        List<String> firstOutputNames = ((LogicalPlan)((Object)this.children().getFirst())).output().stream().map(NamedExpression::name).toList();
        Holder resolved = new Holder((Object)true);
        this.children().stream().skip(1L).forEach(subPlan -> {
            List<String> names = subPlan.output().stream().map(NamedExpression::name).toList();
            if (!names.equals(firstOutputNames)) {
                resolved.set((Object)false);
            }
        });
        return (Boolean)resolved.get();
    }

    protected NodeInfo<? extends LogicalPlan> info() {
        return NodeInfo.create((Node)this, Fork::new, (Object)this.children(), this.output);
    }

    public Fork replaceSubPlans(List<LogicalPlan> subPlans) {
        return new Fork(this.source(), subPlans, this.output);
    }

    @Override
    public List<Attribute> output() {
        return this.output;
    }

    public static List<Attribute> outputUnion(List<LogicalPlan> subplans) {
        ArrayList<Attribute> output = new ArrayList<Attribute>();
        HashSet<String> names = new HashSet<String>();
        Set<String> unsupportedAttributesNames = Fork.outputUnsupportedAttributeNames(subplans);
        for (LogicalPlan subPlan : subplans) {
            for (Attribute attr : subPlan.output()) {
                if (attr.dataType() == DataType.UNSUPPORTED && !unsupportedAttributesNames.contains(attr.name()) || names.contains(attr.name()) || attr == Analyzer.NO_FIELDS.getFirst()) continue;
                names.add(attr.name());
                output.add(attr);
            }
        }
        return output;
    }

    public static Set<String> outputUnsupportedAttributeNames(List<LogicalPlan> subplans) {
        HashSet<String> unsupportedAttributes = new HashSet<String>();
        HashSet<String> names = new HashSet<String>();
        for (LogicalPlan subPlan : subplans) {
            for (Attribute attr : subPlan.output()) {
                String attrName = attr.name();
                if (!unsupportedAttributes.contains(attrName) && attr.dataType() == DataType.UNSUPPORTED && !names.contains(attrName)) {
                    unsupportedAttributes.add(attrName);
                } else if (unsupportedAttributes.contains(attrName) && attr.dataType() != DataType.UNSUPPORTED) {
                    unsupportedAttributes.remove(attrName);
                }
                names.add(attrName);
            }
        }
        return unsupportedAttributes;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Fork.class, this.children());
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Fork other = (Fork)o;
        return Objects.equals(this.children(), other.children());
    }

    @Override
    public BiConsumer<LogicalPlan, Failures> postAnalysisPlanVerification() {
        return Fork::checkFork;
    }

    private static void checkFork(LogicalPlan plan, Failures failures) {
        if (!(plan instanceof Fork)) {
            return;
        }
        Fork fork = (Fork)plan;
        fork.forEachDown(Fork.class, otherFork -> {
            if (fork == otherFork) {
                return;
            }
            failures.add(Failure.fail(otherFork, "Only a single FORK command is supported, but found multiple", new Object[0]));
        });
        Map<String, DataType> outputTypes = fork.output().stream().collect(Collectors.toMap(NamedExpression::name, Expression::dataType));
        fork.children().forEach(subPlan -> {
            for (Attribute attr : subPlan.output()) {
                DataType actual;
                DataType expected = (DataType)outputTypes.get(attr.name());
                if (expected == DataType.UNSUPPORTED || (actual = attr.dataType()) == expected) continue;
                failures.add(Failure.fail(attr, "Column [{}] has conflicting data types in FORK branches: [{}] and [{}]", new Object[]{attr.name(), actual, expected}));
            }
        });
    }
}

