/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.List;
import org.elasticsearch.xpack.esql.VerificationException;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.optimizer.PhysicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.PhysicalVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.physical.ProjectAwayColumns;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRuleExecutor;
import org.elasticsearch.xpack.esql.rule.RuleExecutor;

public class PhysicalPlanOptimizer
extends ParameterizedRuleExecutor<PhysicalPlan, PhysicalOptimizerContext> {
    private static final List<RuleExecutor.Batch<PhysicalPlan>> RULES = List.of(new RuleExecutor.Batch("Plan Boundary", RuleExecutor.Limiter.ONCE, new ProjectAwayColumns()));
    private final PhysicalVerifier verifier = PhysicalVerifier.INSTANCE;

    public PhysicalPlanOptimizer(PhysicalOptimizerContext context) {
        super(context);
    }

    public PhysicalPlan optimize(PhysicalPlan plan) {
        return this.verify(this.execute(plan), plan.output());
    }

    PhysicalPlan verify(PhysicalPlan optimizedPlan, List<Attribute> expectedOutputAttributes) {
        Failures failures = this.verifier.verify(optimizedPlan, false, expectedOutputAttributes);
        if (failures.hasFailures()) {
            throw new VerificationException(failures);
        }
        return optimizedPlan;
    }

    @Override
    protected List<RuleExecutor.Batch<PhysicalPlan>> batches() {
        return RULES;
    }
}

