/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationPlanVerificationAware;
import org.elasticsearch.xpack.esql.capabilities.PostOptimizationVerificationAware;
import org.elasticsearch.xpack.esql.common.Failures;
import org.elasticsearch.xpack.esql.optimizer.PostOptimizationPhasePlanVerifier;
import org.elasticsearch.xpack.esql.optimizer.rules.PlanConsistencyChecker;
import org.elasticsearch.xpack.esql.plan.logical.Enrich;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;

public final class LogicalVerifier
extends PostOptimizationPhasePlanVerifier<LogicalPlan> {
    public static final LogicalVerifier INSTANCE = new LogicalVerifier();

    private LogicalVerifier() {
    }

    @Override
    boolean skipVerification(LogicalPlan optimizedPlan, boolean skipRemoteEnrichVerification) {
        if (skipRemoteEnrichVerification) {
            List enriches = optimizedPlan.collectFirstChildren(Enrich.class::isInstance);
            if (!enriches.isEmpty() && ((Enrich)enriches.get(0)).mode() == Enrich.Mode.REMOTE) {
                return true;
            }
        }
        return false;
    }

    @Override
    void checkPlanConsistency(LogicalPlan optimizedPlan, Failures failures, Failures depFailures) {
        ArrayList checkers = new ArrayList();
        optimizedPlan.forEachUp(p -> {
            PlanConsistencyChecker.checkPlan(p, depFailures);
            if (!failures.hasFailures()) {
                if (p instanceof PostOptimizationVerificationAware) {
                    PostOptimizationVerificationAware pova = (PostOptimizationVerificationAware)((Object)p);
                    pova.postOptimizationVerification(failures);
                }
                if (p instanceof PostOptimizationPlanVerificationAware) {
                    PostOptimizationPlanVerificationAware popva = (PostOptimizationPlanVerificationAware)((Object)p);
                    checkers.add(popva.postOptimizationPlanVerification());
                }
                p.forEachExpression(ex -> {
                    if (ex instanceof PostOptimizationVerificationAware) {
                        PostOptimizationVerificationAware va = (PostOptimizationVerificationAware)ex;
                        va.postOptimizationVerification(failures);
                    }
                });
            }
        });
        optimizedPlan.forEachUp(p -> checkers.forEach(checker -> checker.accept(p, failures)));
    }
}

