/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.aggregate;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.compute.aggregation.AggregatorFunctionSupplier;
import org.elasticsearch.compute.aggregation.RateDoubleGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.RateIntGroupingAggregatorFunction;
import org.elasticsearch.compute.aggregation.RateLongGroupingAggregatorFunction;
import org.elasticsearch.xpack.esql.EsqlIllegalArgumentException;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.expression.TypeResolutions;
import org.elasticsearch.xpack.esql.core.expression.UnresolvedAttribute;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.Example;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesTo;
import org.elasticsearch.xpack.esql.expression.function.FunctionAppliesToLifecycle;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.FunctionType;
import org.elasticsearch.xpack.esql.expression.function.OptionalArgument;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.function.aggregate.TimeSeriesAggregateFunction;
import org.elasticsearch.xpack.esql.io.stream.PlanStreamInput;
import org.elasticsearch.xpack.esql.planner.ToAggregator;

public class Rate
extends TimeSeriesAggregateFunction
implements OptionalArgument,
ToAggregator {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "Rate", Rate::new);
    private final Expression timestamp;

    @FunctionInfo(type=FunctionType.TIME_SERIES_AGGREGATE, returnType={"double"}, description="Calculates the per-second average rate of increase of a [counter](docs-content://manage-data/data-store/data-streams/time-series-data-stream-tsds.md#time-series-metric). Rate calculations account for breaks in monotonicity, such as counter resets when a service restarts, and extrapolate values within each bucketed time interval. Rate is the most appropriate aggregate function for counters. It is only allowed in a [STATS](/reference/query-languages/esql/commands/stats-by.md) command under a [`TS`](/reference/query-languages/esql/commands/ts.md) source command, to be properly applied per time series.", appliesTo={@FunctionAppliesTo(lifeCycle=FunctionAppliesToLifecycle.PREVIEW, version="9.2.0")}, preview=true, examples={@Example(file="k8s-timeseries", tag="rate")})
    public Rate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}) Expression field) {
        this(source, field, (Expression)new UnresolvedAttribute(source, "@timestamp"));
    }

    public Rate(Source source, @Param(name="field", type={"counter_long", "counter_integer", "counter_double"}) Expression field, Expression timestamp) {
        this(source, field, (Expression)Literal.TRUE, timestamp);
    }

    private Rate(Source source, Expression field, Expression filter, List<Expression> children) {
        this(source, field, filter, children.getFirst());
    }

    private Rate(Source source, Expression field, Expression filter, Expression timestamp) {
        super(source, field, filter, List.of(timestamp));
        this.timestamp = timestamp;
    }

    public Rate(StreamInput in) throws IOException {
        this(Source.readFrom((StreamInput)((PlanStreamInput)in)), (Expression)in.readNamedWriteable(Expression.class), (Expression)in.readNamedWriteable(Expression.class), in.readNamedWriteableCollectionAsList(Expression.class));
    }

    public String getWriteableName() {
        return Rate.ENTRY.name;
    }

    protected NodeInfo<Rate> info() {
        return NodeInfo.create((Node)this, Rate::new, (Object)this.field(), (Object)this.timestamp);
    }

    public Rate replaceChildren(List<Expression> newChildren) {
        if (newChildren.size() != 3) {
            assert (false) : "expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren);
            throw new IllegalArgumentException("expected 3 children for field, filter, @timestamp; got " + String.valueOf(newChildren));
        }
        return new Rate(this.source(), newChildren.get(0), newChildren.get(1), newChildren.get(2));
    }

    @Override
    public Rate withFilter(Expression filter) {
        return new Rate(this.source(), this.field(), filter, this.timestamp);
    }

    public DataType dataType() {
        return DataType.DOUBLE;
    }

    @Override
    protected Expression.TypeResolution resolveType() {
        return TypeResolutions.isType((Expression)this.field(), dt -> DataType.isCounter((DataType)dt), (String)this.sourceText(), (TypeResolutions.ParamOrdinal)TypeResolutions.ParamOrdinal.FIRST, (String[])new String[]{"counter_long", "counter_integer", "counter_double"});
    }

    @Override
    public AggregatorFunctionSupplier supplier() {
        DataType type = this.field().dataType();
        return switch (type) {
            case DataType.COUNTER_LONG -> new RateLongGroupingAggregatorFunction.FunctionSupplier(true);
            case DataType.COUNTER_INTEGER -> new RateIntGroupingAggregatorFunction.FunctionSupplier(true);
            case DataType.COUNTER_DOUBLE -> new RateDoubleGroupingAggregatorFunction.FunctionSupplier(true);
            default -> throw EsqlIllegalArgumentException.illegalDataType(type);
        };
    }

    @Override
    public Rate perTimeSeriesAggregation() {
        return this;
    }

    public String toString() {
        return "rate(" + String.valueOf(this.field()) + ")";
    }

    Expression timestamp() {
        return this.timestamp;
    }

    @Override
    public boolean requiredTimeSeriesSource() {
        return true;
    }
}

