/*
 * Decompiled with CFR 0.152.
 */
package com.nvidia.cuvs;

import com.nvidia.cuvs.CuVSDeviceMatrix;
import com.nvidia.cuvs.CuVSHostMatrix;
import com.nvidia.cuvs.CuVSResources;
import com.nvidia.cuvs.RowView;
import com.nvidia.cuvs.spi.CuVSProvider;

public interface CuVSMatrix
extends AutoCloseable {
    public static CuVSMatrix ofArray(float[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static CuVSMatrix ofArray(int[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static CuVSMatrix ofArray(byte[][] vectors) {
        return CuVSProvider.provider().newMatrixFromArray(vectors);
    }

    public static Builder<CuVSHostMatrix> hostBuilder(long size, long columns, DataType dataType) {
        return CuVSProvider.provider().newHostMatrixBuilder(size, columns, dataType);
    }

    public static Builder<CuVSHostMatrix> hostBuilder(long size, long columns, int rowStride, int columnStride, DataType dataType) {
        return CuVSProvider.provider().newHostMatrixBuilder(size, columns, rowStride, columnStride, dataType);
    }

    public static Builder<CuVSDeviceMatrix> deviceBuilder(CuVSResources resources, long size, long columns, DataType dataType) {
        return CuVSProvider.provider().newDeviceMatrixBuilder(resources, size, columns, dataType);
    }

    public static Builder<CuVSDeviceMatrix> deviceBuilder(CuVSResources resources, long size, long columns, int rowStride, int columnStride, DataType dataType) {
        return CuVSProvider.provider().newDeviceMatrixBuilder(resources, size, columns, rowStride, columnStride, dataType);
    }

    public long size();

    public long columns();

    public DataType dataType();

    public RowView getRow(long var1);

    public void toArray(int[][] var1);

    public void toArray(float[][] var1);

    public void toArray(byte[][] var1);

    public void toHost(CuVSHostMatrix var1);

    public CuVSHostMatrix toHost();

    public void toDevice(CuVSDeviceMatrix var1, CuVSResources var2);

    public CuVSDeviceMatrix toDevice(CuVSResources var1);

    @Override
    public void close();

    public static enum DataType {
        FLOAT,
        INT,
        UINT,
        BYTE;

    }

    public static interface Builder<T extends CuVSMatrix> {
        public void addVector(float[] var1);

        public void addVector(byte[] var1);

        public void addVector(int[] var1);

        public T build();
    }

    public static enum MemoryKind {
        HOST,
        DEVICE;

    }
}

