/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.extras;

import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.intervals.Intervals;
import org.apache.lucene.queries.intervals.IntervalsSource;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOFunction;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.elasticsearch.common.CheckedIntFunction;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.text.UTF8DecodingReader;
import org.elasticsearch.common.unit.Fuzziness;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.analysis.IndexAnalyzers;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.FieldDataContext;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SourceValueFetcherSortedBinaryIndexFieldData;
import org.elasticsearch.index.fielddata.StoredFieldSortedBinaryIndexFieldData;
import org.elasticsearch.index.fieldvisitor.LeafStoredFieldLoader;
import org.elasticsearch.index.fieldvisitor.StoredFieldLoader;
import org.elasticsearch.index.mapper.BlockLoader;
import org.elasticsearch.index.mapper.BlockSourceReader;
import org.elasticsearch.index.mapper.BlockStoredFieldsReader;
import org.elasticsearch.index.mapper.DocumentParserContext;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldNamesFieldMapper;
import org.elasticsearch.index.mapper.KeywordFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilderContext;
import org.elasticsearch.index.mapper.SourceValueFetcher;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.StringStoredFieldFieldLoader;
import org.elasticsearch.index.mapper.TextFieldMapper;
import org.elasticsearch.index.mapper.TextParams;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.mapper.ValueFetcher;
import org.elasticsearch.index.mapper.extras.SourceConfirmedTextQuery;
import org.elasticsearch.index.mapper.extras.SourceIntervalsSource;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.field.TextDocValuesField;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.lookup.SearchLookup;
import org.elasticsearch.search.lookup.SourceProvider;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentString;

public class MatchOnlyTextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "match_only_text";
    public static final FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, c.indexVersionCreated(), c.getIndexAnalyzers(), c.isWithinMultiField(), MatchOnlyTextFieldMapper.isSyntheticSourceStoredFieldInBinaryFormat(c.indexVersionCreated())));
    private final IndexVersion indexCreatedVersion;
    private final IndexAnalyzers indexAnalyzers;
    private final NamedAnalyzer indexAnalyzer;
    private final int positionIncrementGap;
    private final boolean storeSource;
    private final FieldType fieldType;
    private final boolean withinMultiField;
    private final boolean storedFieldInBinaryFormat;

    private static boolean isSyntheticSourceStoredFieldInBinaryFormat(IndexVersion indexCreatedVersion) {
        return indexCreatedVersion.onOrAfter((VersionId)IndexVersions.MATCH_ONLY_TEXT_STORED_AS_BYTES) || indexCreatedVersion.between((VersionId)IndexVersions.MATCH_ONLY_TEXT_STORED_AS_BYTES_BACKPORT_8_X, (VersionId)IndexVersions.UPGRADE_TO_LUCENE_10_0_0);
    }

    private MatchOnlyTextFieldMapper(String simpleName, FieldType fieldType, MatchOnlyTextFieldType mappedFieldType, FieldMapper.BuilderParams builderParams, boolean storeSource, Builder builder) {
        super(simpleName, (MappedFieldType)mappedFieldType, builderParams);
        assert (mappedFieldType.getTextSearchInfo().isTokenized());
        assert (!mappedFieldType.hasDocValues());
        this.fieldType = MatchOnlyTextFieldMapper.freezeAndDeduplicateFieldType((FieldType)fieldType);
        this.indexCreatedVersion = builder.indexCreatedVersion;
        this.indexAnalyzers = builder.analyzers.indexAnalyzers;
        this.indexAnalyzer = builder.analyzers.getIndexAnalyzer();
        this.positionIncrementGap = (Integer)builder.analyzers.positionIncrementGap.getValue();
        this.storeSource = storeSource;
        this.withinMultiField = builder.withinMultiField;
        this.storedFieldInBinaryFormat = builder.storedFieldInBinaryFormat;
    }

    public Map<String, NamedAnalyzer> indexAnalyzers() {
        return Map.of(this.mappedFieldType.name(), this.indexAnalyzer);
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.leafName(), this.indexCreatedVersion, this.indexAnalyzers, this.withinMultiField, this.storedFieldInBinaryFormat).init(this);
    }

    protected void parseCreateField(DocumentParserContext context) throws IOException {
        XContentString value = context.parser().optimizedTextOrNull();
        if (value == null) {
            return;
        }
        XContentString.UTF8Bytes utfBytes = value.bytes();
        Field field = new Field(this.fieldType().name(), (Reader)new UTF8DecodingReader(utfBytes), (IndexableFieldType)this.fieldType);
        context.doc().add((IndexableField)field);
        context.addToFieldNames(this.fieldType().name());
        if (this.storeSource) {
            if (this.storedFieldInBinaryFormat) {
                BytesRef bytesRef = new BytesRef(utfBytes.bytes(), utfBytes.offset(), utfBytes.length());
                context.doc().add((IndexableField)new StoredField(this.fieldType().storedFieldNameForSyntheticSource(), bytesRef));
            } else {
                context.doc().add((IndexableField)new StoredField(this.fieldType().storedFieldNameForSyntheticSource(), value.string()));
            }
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public MatchOnlyTextFieldType fieldType() {
        return (MatchOnlyTextFieldType)super.fieldType();
    }

    protected FieldMapper.SyntheticSourceSupport syntheticSourceSupport() {
        if (this.storeSource) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> new StringStoredFieldFieldLoader(this, this.fieldType().storedFieldNameForSyntheticSource(), this.fieldType().name(), this.leafName()){

                protected void write(XContentBuilder b, Object value) throws IOException {
                    if (value instanceof BytesRef) {
                        BytesRef valueBytes = (BytesRef)value;
                        b.value(valueBytes.utf8ToString());
                    } else {
                        assert (value instanceof String);
                        b.value(value.toString());
                    }
                }
            });
        }
        KeywordFieldMapper kwd = TextFieldMapper.SyntheticSourceHelper.getKeywordFieldMapperForSyntheticSource((Iterable)((Object)this));
        if (kwd != null) {
            return new FieldMapper.SyntheticSourceSupport.Native(() -> kwd.syntheticFieldLoader(this.fullPath(), this.leafName()));
        }
        assert (false) : "there should be a suite field mapper with native synthetic source support";
        return super.syntheticSourceSupport();
    }

    public static class MatchOnlyTextFieldType
    extends StringFieldType {
        private final Analyzer indexAnalyzer;
        private final TextFieldMapper.TextFieldType textFieldType;
        private final String originalName;
        private final boolean withinMultiField;
        private final boolean storedFieldInBinaryFormat;

        public MatchOnlyTextFieldType(String name, TextSearchInfo tsi, Analyzer indexAnalyzer, boolean isSyntheticSource, Map<String, String> meta, boolean withinMultiField, boolean storedFieldInBinaryFormat, KeywordFieldMapper.KeywordFieldType syntheticSourceDelegate) {
            super(name, true, false, false, tsi, meta);
            this.indexAnalyzer = Objects.requireNonNull(indexAnalyzer);
            this.textFieldType = new TextFieldMapper.TextFieldType(name, isSyntheticSource, syntheticSourceDelegate);
            this.originalName = isSyntheticSource ? name + "._original" : null;
            this.withinMultiField = withinMultiField;
            this.storedFieldInBinaryFormat = storedFieldInBinaryFormat;
        }

        public MatchOnlyTextFieldType(String name) {
            this(name, new TextSearchInfo(Defaults.FIELD_TYPE, null, Lucene.STANDARD_ANALYZER, Lucene.STANDARD_ANALYZER), (Analyzer)Lucene.STANDARD_ANALYZER, false, Collections.emptyMap(), false, false, null);
        }

        public String typeName() {
            return MatchOnlyTextFieldMapper.CONTENT_TYPE;
        }

        public String familyTypeName() {
            return "text";
        }

        public ValueFetcher valueFetcher(SearchExecutionContext context, String format) {
            return SourceValueFetcher.toString((String)this.name(), (SearchExecutionContext)context, (String)format);
        }

        private IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> getValueFetcherProvider(SearchExecutionContext searchExecutionContext) {
            if (!searchExecutionContext.isSourceEnabled()) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [match_only_text] cannot run positional queries since [_source] is disabled.");
            }
            if (searchExecutionContext.isSourceSynthetic() && this.withinMultiField) {
                KeywordFieldMapper.KeywordFieldType keywordParent;
                String parentField = searchExecutionContext.parentPath(this.name());
                MappedFieldType parent = searchExecutionContext.lookup().fieldType(parentField);
                if (parent instanceof KeywordFieldMapper.KeywordFieldType && (keywordParent = (KeywordFieldMapper.KeywordFieldType)parent).ignoreAbove().isSet()) {
                    if (parent.isStored()) {
                        return MatchOnlyTextFieldType.storedFieldFetcher(parentField, keywordParent.originalName());
                    }
                    if (parent.hasDocValues()) {
                        IndexFieldData ifd = searchExecutionContext.getForField(parent, MappedFieldType.FielddataOperation.SEARCH);
                        return MatchOnlyTextFieldType.combineFieldFetchers(MatchOnlyTextFieldType.docValuesFieldFetcher(ifd), MatchOnlyTextFieldType.storedFieldFetcher(keywordParent.originalName()));
                    }
                }
                if (parent.isStored()) {
                    return MatchOnlyTextFieldType.storedFieldFetcher(parentField);
                }
                if (parent.hasDocValues()) {
                    IndexFieldData ifd = searchExecutionContext.getForField(parent, MappedFieldType.FielddataOperation.SEARCH);
                    return MatchOnlyTextFieldType.docValuesFieldFetcher(ifd);
                }
                assert (false) : "parent field should either be stored or have doc values";
            } else if (searchExecutionContext.isSourceSynthetic() && this.textFieldType.syntheticSourceDelegate() != null) {
                KeywordFieldMapper.KeywordFieldType kwd = this.textFieldType.syntheticSourceDelegate();
                if (kwd != null) {
                    if (kwd.ignoreAbove().isSet()) {
                        if (kwd.isStored()) {
                            return MatchOnlyTextFieldType.storedFieldFetcher(kwd.name(), kwd.originalName());
                        }
                        if (kwd.hasDocValues()) {
                            IndexFieldData ifd = searchExecutionContext.getForField((MappedFieldType)kwd, MappedFieldType.FielddataOperation.SEARCH);
                            return MatchOnlyTextFieldType.combineFieldFetchers(MatchOnlyTextFieldType.docValuesFieldFetcher(ifd), MatchOnlyTextFieldType.storedFieldFetcher(kwd.originalName()));
                        }
                    }
                    if (kwd.isStored()) {
                        return MatchOnlyTextFieldType.storedFieldFetcher(kwd.name());
                    }
                    if (kwd.hasDocValues()) {
                        IndexFieldData ifd = searchExecutionContext.getForField((MappedFieldType)kwd, MappedFieldType.FielddataOperation.SEARCH);
                        return MatchOnlyTextFieldType.docValuesFieldFetcher(ifd);
                    }
                    assert (false) : "multi field should either be stored or have doc values";
                } else assert (false) : "multi field of type keyword should exist";
            } else if (searchExecutionContext.isSourceSynthetic()) {
                String name = this.storedFieldNameForSyntheticSource();
                return MatchOnlyTextFieldType.storedFieldFetcher(name);
            }
            ValueFetcher valueFetcher = this.valueFetcher(searchExecutionContext, null);
            SearchLookup sourceProvider = searchExecutionContext.lookup();
            return arg_0 -> MatchOnlyTextFieldType.lambda$getValueFetcherProvider$1(valueFetcher, (SourceProvider)sourceProvider, arg_0);
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> docValuesFieldFetcher(IndexFieldData<?> ifd) {
            return context -> {
                SortedBinaryDocValues sortedBinaryDocValues = ifd.load(context).getBytesValues();
                return docId -> {
                    if (sortedBinaryDocValues.advanceExact(docId)) {
                        ArrayList<String> values = new ArrayList<String>(sortedBinaryDocValues.docValueCount());
                        for (int i = 0; i < sortedBinaryDocValues.docValueCount(); ++i) {
                            values.add(sortedBinaryDocValues.nextValue().utf8ToString());
                        }
                        return values;
                    }
                    return List.of();
                };
            };
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> storedFieldFetcher(String ... names) {
            StoredFieldLoader loader = StoredFieldLoader.create((boolean)false, Set.of(names));
            return context -> {
                LeafStoredFieldLoader leafLoader = loader.getLoader(context, null);
                return docId -> {
                    leafLoader.advanceTo(docId);
                    Map storedFields = leafLoader.storedFields();
                    if (names.length == 1) {
                        return (List)storedFields.get(names[0]);
                    }
                    ArrayList values = new ArrayList();
                    for (String name : names) {
                        List currValues = (List)storedFields.get(name);
                        if (currValues == null) continue;
                        values.addAll(currValues);
                    }
                    return values;
                };
            };
        }

        private static IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> combineFieldFetchers(IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> primaryFetcher, IOFunction<LeafReaderContext, CheckedIntFunction<List<Object>, IOException>> secondaryFetcher) {
            return context -> {
                CheckedIntFunction primaryGetter = (CheckedIntFunction)primaryFetcher.apply(context);
                CheckedIntFunction secondaryGetter = (CheckedIntFunction)secondaryFetcher.apply(context);
                return docId -> {
                    List secondary;
                    ArrayList values = new ArrayList();
                    List primary = (List)primaryGetter.apply(docId);
                    if (primary != null) {
                        values.addAll(primary);
                    }
                    if ((secondary = (List)secondaryGetter.apply(docId)) != null) {
                        values.addAll(secondary);
                    }
                    assert (primary != null || secondary != null);
                    return values;
                };
            };
        }

        private Query toQuery(Query query, SearchExecutionContext searchExecutionContext) {
            return new ConstantScoreQuery((Query)new SourceConfirmedTextQuery(query, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer));
        }

        private IntervalsSource toIntervalsSource(IntervalsSource source, Query approximation, SearchExecutionContext searchExecutionContext) {
            return new SourceIntervalsSource(source, approximation, this.getValueFetcherProvider(searchExecutionContext), this.indexAnalyzer);
        }

        public Query termQuery(Object value, SearchExecutionContext context) {
            return new ConstantScoreQuery(super.termQuery(value, context));
        }

        public Query fuzzyQuery(Object value, Fuzziness fuzziness, int prefixLength, int maxExpansions, boolean transpositions, SearchExecutionContext context, MultiTermQuery.RewriteMethod rewriteMethod) {
            return new ConstantScoreQuery(super.fuzzyQuery(value, fuzziness, prefixLength, maxExpansions, transpositions, context, rewriteMethod));
        }

        public IntervalsSource termIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.term((BytesRef)term), (Query)new TermQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource prefixIntervals(BytesRef term, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.prefix((BytesRef)term, (int)IndexSearcher.getMaxClauseCount()), (Query)new PrefixQuery(new Term(this.name(), term)), context);
        }

        public IntervalsSource fuzzyIntervals(String term, int maxDistance, int prefixLength, boolean transpositions, SearchExecutionContext context) {
            FuzzyQuery fuzzyQuery = new FuzzyQuery(new Term(this.name(), term), maxDistance, prefixLength, IndexSearcher.getMaxClauseCount(), transpositions, MultiTermQuery.CONSTANT_SCORE_BLENDED_REWRITE);
            IntervalsSource fuzzyIntervals = Intervals.multiterm((CompiledAutomaton)fuzzyQuery.getAutomata(), (int)IndexSearcher.getMaxClauseCount(), (String)term);
            return this.toIntervalsSource(fuzzyIntervals, (Query)fuzzyQuery, context);
        }

        public IntervalsSource wildcardIntervals(BytesRef pattern, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.wildcard((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public IntervalsSource regexpIntervals(BytesRef pattern, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.regexp((BytesRef)pattern, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public IntervalsSource rangeIntervals(BytesRef lowerTerm, BytesRef upperTerm, boolean includeLower, boolean includeUpper, SearchExecutionContext context) {
            return this.toIntervalsSource(Intervals.range((BytesRef)lowerTerm, (BytesRef)upperTerm, (boolean)includeLower, (boolean)includeUpper, (int)IndexSearcher.getMaxClauseCount()), (Query)new MatchAllDocsQuery(), context);
        }

        public Query phraseQuery(TokenStream stream, int slop, boolean enablePosIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phraseQuery(stream, slop, enablePosIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query multiPhraseQuery(TokenStream stream, int slop, boolean enablePositionIncrements, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.multiPhraseQuery(stream, slop, enablePositionIncrements, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public Query phrasePrefixQuery(TokenStream stream, int slop, int maxExpansions, SearchExecutionContext queryShardContext) throws IOException {
            Query query = this.textFieldType.phrasePrefixQuery(stream, slop, maxExpansions, queryShardContext);
            return this.toQuery(query, queryShardContext);
        }

        public BlockLoader blockLoader(MappedFieldType.BlockLoaderContext blContext) {
            if (this.textFieldType.isSyntheticSource()) {
                if (this.textFieldType.syntheticSourceDelegate() == null) {
                    if (this.storedFieldInBinaryFormat) {
                        return new BlockStoredFieldsReader.BytesFromBytesRefsBlockLoader(this.storedFieldNameForSyntheticSource());
                    }
                    return new BytesFromMixedStringsBytesRefBlockLoader(this.storedFieldNameForSyntheticSource());
                }
                if (this.textFieldType.canUseSyntheticSourceDelegateForLoading()) {
                    return new BlockLoader.Delegating(this.textFieldType.syntheticSourceDelegate().blockLoader(blContext)){

                        protected String delegatingTo() {
                            return textFieldType.syntheticSourceDelegate().name();
                        }
                    };
                }
            }
            SourceValueFetcher fetcher = SourceValueFetcher.toString((Set)blContext.sourcePaths(this.name()));
            BlockSourceReader.LeafIteratorLookup lookup = BlockSourceReader.lookupFromFieldNames((FieldNamesFieldMapper.FieldNamesFieldType)blContext.fieldNames(), (String)this.name());
            return new BlockSourceReader.BytesRefsBlockLoader((ValueFetcher)fetcher, lookup);
        }

        public IndexFieldData.Builder fielddataBuilder(FieldDataContext fieldDataContext) {
            if (fieldDataContext.fielddataOperation() != MappedFieldType.FielddataOperation.SCRIPT) {
                throw new IllegalArgumentException("match_only_text fields do not support sorting and aggregations");
            }
            if (this.textFieldType.isSyntheticSource()) {
                return (cache, breaker) -> new StoredFieldSortedBinaryIndexFieldData(this, this.storedFieldNameForSyntheticSource(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, TextDocValuesField::new){

                    protected BytesRef storedToBytesRef(Object stored) {
                        if (stored instanceof BytesRef) {
                            BytesRef storedBytes = (BytesRef)stored;
                            return storedBytes;
                        }
                        assert (stored instanceof String);
                        return new BytesRef((CharSequence)stored.toString());
                    }
                };
            }
            return new SourceValueFetcherSortedBinaryIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.KEYWORD, (ValueFetcher)SourceValueFetcher.toString((Set)((Set)fieldDataContext.sourcePathsLookup().apply(this.name()))), (SourceProvider)fieldDataContext.lookupSupplier().get(), TextDocValuesField::new);
        }

        private String storedFieldNameForSyntheticSource() {
            return this.originalName;
        }

        private static /* synthetic */ CheckedIntFunction lambda$getValueFetcherProvider$1(ValueFetcher valueFetcher, SourceProvider sourceProvider, LeafReaderContext context) throws IOException {
            valueFetcher.setNextReader(context);
            return docID -> {
                try {
                    return valueFetcher.fetchValues(sourceProvider.getSource(context, docID), docID, new ArrayList());
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            };
        }

        static class BytesFromMixedStringsBytesRefBlockLoader
        extends BlockStoredFieldsReader.StoredFieldsBlockLoader {
            BytesFromMixedStringsBytesRefBlockLoader(String field) {
                super(field);
            }

            public BlockLoader.Builder builder(BlockLoader.BlockFactory factory, int expectedCount) {
                return factory.bytesRefs(expectedCount);
            }

            public BlockLoader.RowStrideReader rowStrideReader(LeafReaderContext context) throws IOException {
                return new BlockStoredFieldsReader.Bytes(this, this.field){
                    private final BytesRef scratch = new BytesRef();

                    protected BytesRef toBytesRef(Object v) {
                        if (v instanceof BytesRef) {
                            BytesRef b = (BytesRef)v;
                            return b;
                        }
                        assert (v instanceof String);
                        return BlockSourceReader.toBytesRef((BytesRef)this.scratch, (String)v.toString());
                    }
                };
            }
        }
    }

    public static class Builder
    extends FieldMapper.Builder {
        private final IndexVersion indexCreatedVersion;
        private final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();
        private final TextParams.Analyzers analyzers;
        private final boolean withinMultiField;
        private final boolean storedFieldInBinaryFormat;

        public Builder(String name, IndexVersion indexCreatedVersion, IndexAnalyzers indexAnalyzers, boolean withinMultiField, boolean storedFieldInBinaryFormat) {
            super(name);
            this.indexCreatedVersion = indexCreatedVersion;
            this.analyzers = new TextParams.Analyzers(indexAnalyzers, m -> ((MatchOnlyTextFieldMapper)m).indexAnalyzer, m -> ((MatchOnlyTextFieldMapper)m).positionIncrementGap, indexCreatedVersion);
            this.withinMultiField = withinMultiField;
            this.storedFieldInBinaryFormat = storedFieldInBinaryFormat;
        }

        protected FieldMapper.Parameter<?>[] getParameters() {
            return new FieldMapper.Parameter[]{this.meta};
        }

        private MatchOnlyTextFieldType buildFieldType(MapperBuilderContext context, FieldMapper.MultiFields multiFields) {
            NamedAnalyzer searchAnalyzer = this.analyzers.getSearchAnalyzer();
            NamedAnalyzer searchQuoteAnalyzer = this.analyzers.getSearchQuoteAnalyzer();
            NamedAnalyzer indexAnalyzer = this.analyzers.getIndexAnalyzer();
            TextSearchInfo tsi = new TextSearchInfo(Defaults.FIELD_TYPE, null, searchAnalyzer, searchQuoteAnalyzer);
            return new MatchOnlyTextFieldType(context.buildFullName(this.leafName()), tsi, (Analyzer)indexAnalyzer, context.isSourceSynthetic(), (Map)this.meta.getValue(), this.withinMultiField, this.storedFieldInBinaryFormat, TextFieldMapper.SyntheticSourceHelper.syntheticSourceDelegate((boolean)false, (FieldMapper.MultiFields)multiFields));
        }

        public MatchOnlyTextFieldMapper build(MapperBuilderContext context) {
            FieldMapper.BuilderParams builderParams = this.builderParams((Mapper.Builder)this, context);
            MatchOnlyTextFieldType tft = this.buildFieldType(context, builderParams.multiFields());
            boolean storeSource = TextFieldMapper.Builder.multiFieldsNotStoredByDefaultIndexVersionCheck((IndexVersion)this.indexCreatedVersion) ? context.isSourceSynthetic() && !this.withinMultiField && !this.multiFieldsBuilder.hasSyntheticSourceCompatibleKeywordField() : context.isSourceSynthetic();
            return new MatchOnlyTextFieldMapper(this.leafName(), Defaults.FIELD_TYPE, tft, this.builderParams((Mapper.Builder)this, context), storeSource, this);
        }
    }

    public static class Defaults {
        public static final FieldType FIELD_TYPE;

        static {
            FieldType ft = new FieldType();
            ft.setTokenized(true);
            ft.setStored(false);
            ft.setStoreTermVectors(false);
            ft.setOmitNorms(true);
            ft.setIndexOptions(IndexOptions.DOCS);
            FIELD_TYPE = Mapper.freezeAndDeduplicateFieldType((FieldType)ft);
        }
    }
}

