/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import org.elasticsearch.common.ssl.KeyStoreUtil;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.ssl.StoredCertificate;

public class CompositeTrustConfig
implements SslTrustConfig {
    private final List<SslTrustConfig> configs;

    CompositeTrustConfig(List<SslTrustConfig> configs) {
        this.configs = List.copyOf(configs);
    }

    @Override
    public Collection<Path> getDependentFiles() {
        return this.configs.stream().map(SslTrustConfig::getDependentFiles).flatMap(Collection::stream).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public boolean isSystemDefault() {
        return this.configs.stream().allMatch(SslTrustConfig::isSystemDefault);
    }

    @Override
    public boolean hasExplicitConfig() {
        return this.configs.stream().allMatch(SslTrustConfig::hasExplicitConfig);
    }

    @Override
    public X509ExtendedTrustManager createTrustManager() {
        try {
            Collection trustedIssuers = this.configs.stream().map(c -> c.createTrustManager()).map(tm -> tm.getAcceptedIssuers()).flatMap(Arrays::stream).collect(Collectors.toSet());
            KeyStore store = KeyStoreUtil.buildTrustStore(trustedIssuers);
            return KeyStoreUtil.createTrustManager(store, TrustManagerFactory.getDefaultAlgorithm());
        }
        catch (GeneralSecurityException e) {
            throw new SslConfigException("Cannot combine trust configurations [" + this.configs.stream().map((Function<SslTrustConfig, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/elasticsearch/common/ssl/SslTrustConfig;)Ljava/lang/String;)()).collect(Collectors.joining(",")) + "]", e);
        }
    }

    @Override
    public Collection<? extends StoredCertificate> getConfiguredCertificates() {
        return this.configs.stream().map(SslTrustConfig::getConfiguredCertificates).flatMap(Collection::stream).toList();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeTrustConfig that = (CompositeTrustConfig)o;
        return this.configs.equals(that.configs);
    }

    public int hashCode() {
        return Objects.hash(this.configs);
    }

    public String toString() {
        return "Composite-Trust{" + this.configs.stream().map((Function<SslTrustConfig, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toString(), (Lorg/elasticsearch/common/ssl/SslTrustConfig;)Ljava/lang/String;)()).collect(Collectors.joining(",")) + "}";
    }
}

