/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.migrate.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.LegacyActionRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class CreateIndexFromSourceAction
extends ActionType<AcknowledgedResponse> {
    public static final String NAME = "indices:admin/index/create_from_source";
    public static final ActionType<AcknowledgedResponse> INSTANCE = new CreateIndexFromSourceAction();

    private CreateIndexFromSourceAction() {
        super(NAME);
    }

    public static class Request
    extends LegacyActionRequest
    implements IndicesRequest,
    ToXContent {
        private final String sourceIndex;
        private final String destIndex;
        private Settings settingsOverride;
        private Map<String, Object> mappingsOverride;
        private boolean removeIndexBlocks;
        private static final ParseField SETTINGS_OVERRIDE_FIELD = new ParseField("settings_override", new String[0]);
        private static final ParseField MAPPINGS_OVERRIDE_FIELD = new ParseField("mappings_override", new String[0]);
        private static final ParseField REMOVE_INDEX_BLOCKS_FIELD = new ParseField("remove_index_blocks", new String[0]);
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("create_index_from_source_request");

        public Request(String sourceIndex, String destIndex) {
            this(sourceIndex, destIndex, Settings.EMPTY, Map.of(), true);
        }

        public Request(String sourceIndex, String destIndex, Settings settingsOverride, Map<String, Object> mappingsOverride, boolean removeIndexBlocks) {
            Objects.requireNonNull(settingsOverride);
            Objects.requireNonNull(mappingsOverride);
            this.sourceIndex = sourceIndex;
            this.destIndex = destIndex;
            this.settingsOverride = settingsOverride;
            this.mappingsOverride = mappingsOverride;
            this.removeIndexBlocks = removeIndexBlocks;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.sourceIndex = in.readString();
            this.destIndex = in.readString();
            this.settingsOverride = Settings.readSettingsFromStream((StreamInput)in);
            this.mappingsOverride = (Map)in.readGenericValue();
            this.removeIndexBlocks = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.sourceIndex);
            out.writeString(this.destIndex);
            this.settingsOverride.writeTo(out);
            out.writeGenericValue(this.mappingsOverride);
            out.writeBoolean(this.removeIndexBlocks);
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public String sourceIndex() {
            return this.sourceIndex;
        }

        public String destIndex() {
            return this.destIndex;
        }

        public Settings settingsOverride() {
            return this.settingsOverride;
        }

        public Map<String, Object> mappingsOverride() {
            return this.mappingsOverride;
        }

        public boolean removeIndexBlocks() {
            return this.removeIndexBlocks;
        }

        public void settingsOverride(Settings settingsOverride) {
            this.settingsOverride = settingsOverride;
        }

        public void mappingsOverride(Map<String, Object> mappingsOverride) {
            this.mappingsOverride = mappingsOverride;
        }

        public void removeIndexBlocks(boolean removeIndexBlocks) {
            this.removeIndexBlocks = removeIndexBlocks;
        }

        public void fromXContent(XContentParser parser) throws IOException {
            PARSER.parse(parser, (Object)this, null);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.mappingsOverride.containsKey("_doc")) {
                builder.field(MAPPINGS_OVERRIDE_FIELD.getPreferredName(), this.mappingsOverride.get("_doc"));
            }
            if (!this.settingsOverride.isEmpty()) {
                builder.startObject(SETTINGS_OVERRIDE_FIELD.getPreferredName());
                this.settingsOverride.toXContent(builder, params);
                builder.endObject();
            }
            builder.field(REMOVE_INDEX_BLOCKS_FIELD.getPreferredName(), this.removeIndexBlocks);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.sourceIndex, request.sourceIndex) && Objects.equals(this.destIndex, request.destIndex) && Objects.equals(this.settingsOverride, request.settingsOverride) && Objects.equals(this.mappingsOverride, request.mappingsOverride) && this.removeIndexBlocks == request.removeIndexBlocks;
        }

        public int hashCode() {
            return Objects.hash(this.sourceIndex, this.destIndex, this.settingsOverride, this.mappingsOverride, this.removeIndexBlocks);
        }

        public String[] indices() {
            return new String[]{this.sourceIndex};
        }

        public IndicesOptions indicesOptions() {
            return IndicesOptions.strictSingleIndexNoExpandForbidClosed();
        }

        public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
            return new CancellableTask(id, type, action, this.getDescription(), parentTaskId, headers);
        }

        public String getDescription() {
            return "creating index " + this.destIndex + " from " + this.sourceIndex;
        }

        static {
            PARSER.declareField((parser, request, context) -> request.settingsOverride(Settings.fromXContent((XContentParser)parser)), SETTINGS_OVERRIDE_FIELD, ObjectParser.ValueType.OBJECT);
            PARSER.declareField((parser, request, context) -> request.mappingsOverride(Map.of("_doc", parser.map())), MAPPINGS_OVERRIDE_FIELD, ObjectParser.ValueType.OBJECT);
            PARSER.declareField((parser, request, context) -> request.removeIndexBlocks(parser.booleanValue()), REMOVE_INDEX_BLOCKS_FIELD, ObjectParser.ValueType.BOOLEAN);
        }
    }
}

