/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.services.custom.response;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.inference.results.ChatCompletionResults;
import org.elasticsearch.xpack.inference.common.MapPathExtractor;
import org.elasticsearch.xpack.inference.services.ServiceUtils;
import org.elasticsearch.xpack.inference.services.custom.response.BaseCustomResponseParser;

public class CompletionResponseParser
extends BaseCustomResponseParser {
    public static final String NAME = "completion_response_parser";
    public static final String COMPLETION_PARSER_RESULT = "completion_result";
    private final String completionResultPath;

    public static CompletionResponseParser fromMap(Map<String, Object> responseParserMap, String scope, ValidationException validationException) {
        String path = ServiceUtils.extractRequiredString(responseParserMap, COMPLETION_PARSER_RESULT, String.join((CharSequence)".", scope, "json_parser"), validationException);
        if (!validationException.validationErrors().isEmpty()) {
            throw validationException;
        }
        return new CompletionResponseParser(path);
    }

    public CompletionResponseParser(String completionResultPath) {
        this.completionResultPath = Objects.requireNonNull(completionResultPath);
    }

    public CompletionResponseParser(StreamInput in) throws IOException {
        this.completionResultPath = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.completionResultPath);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("json_parser");
        builder.field(COMPLETION_PARSER_RESULT, this.completionResultPath);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompletionResponseParser that = (CompletionResponseParser)o;
        return Objects.equals(this.completionResultPath, that.completionResultPath);
    }

    public int hashCode() {
        return Objects.hash(this.completionResultPath);
    }

    public String getWriteableName() {
        return NAME;
    }

    public ChatCompletionResults transform(Map<String, Object> map) {
        MapPathExtractor.Result result = MapPathExtractor.extract(map, this.completionResultPath);
        Object extractedField = result.extractedObject();
        CompletionResponseParser.validateNonNull(extractedField, this.completionResultPath);
        if (extractedField instanceof List) {
            List extractedList = (List)extractedField;
            List<String> completionList = CompletionResponseParser.castList(extractedList, (obj, fieldName) -> CompletionResponseParser.toType(obj, String.class, fieldName), this.completionResultPath);
            return new ChatCompletionResults(completionList.stream().map(ChatCompletionResults.Result::new).toList());
        }
        if (extractedField instanceof String) {
            String extractedString = (String)extractedField;
            return new ChatCompletionResults(List.of(new ChatCompletionResults.Result(extractedString)));
        }
        throw new IllegalArgumentException(Strings.format((String)"Extracted field [%s] from path [%s] is an invalid type, expected a list or a string but received [%s]", (Object[])new Object[]{result.getArrayFieldName(0), this.completionResultPath, extractedField.getClass().getSimpleName()}));
    }
}

