/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.response.streaming;

import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.inference.common.DelegatingProcessor;
import org.elasticsearch.xpack.inference.external.http.HttpResult;

public class NewlineDelimitedByteProcessor
extends DelegatingProcessor<HttpResult, Deque<String>> {
    private static final Pattern END_OF_LINE_REGEX = Pattern.compile("\\n|\\r\\n");
    private volatile String previousTokens = "";

    @Override
    protected void next(HttpResult item) {
        if (item.isBodyEmpty()) {
            this.upstream().request(1L);
            return;
        }
        String body = this.previousTokens + new String(item.body(), StandardCharsets.UTF_8);
        String[] lines = END_OF_LINE_REGEX.split(body, -1);
        ArrayDeque<String> results = new ArrayDeque<String>(lines.length);
        for (int i = 0; i < lines.length - 1; ++i) {
            String line = lines[i].trim();
            if (line.isBlank()) continue;
            results.offer(line);
        }
        this.previousTokens = lines[lines.length - 1].trim();
        if (results.isEmpty()) {
            this.upstream().request(1L);
        } else {
            this.downstream().onNext(results);
        }
    }

    @Override
    public void onComplete() {
        if (this.previousTokens.isBlank()) {
            super.onComplete();
        } else if (this.isClosed.compareAndSet(false, true)) {
            ArrayDeque<String> results = new ArrayDeque<String>(1);
            results.offer(this.previousTokens);
            this.downstream().onNext(results);
        }
    }
}

