/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.rank.vectors.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.FormattedDocValues;
import org.elasticsearch.index.fielddata.LeafFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.mapper.vectors.DenseVectorFieldMapper;
import org.elasticsearch.script.field.DocValuesScriptFieldFactory;
import org.elasticsearch.script.field.vectors.BitRankVectorsDocValuesField;
import org.elasticsearch.script.field.vectors.ByteRankVectorsDocValuesField;
import org.elasticsearch.script.field.vectors.FloatRankVectorsDocValuesField;
import org.elasticsearch.search.DocValueFormat;

final class RankVectorsDVLeafFieldData
implements LeafFieldData {
    private final LeafReader reader;
    private final String field;
    private final DenseVectorFieldMapper.ElementType elementType;
    private final int dims;

    RankVectorsDVLeafFieldData(LeafReader reader, String field, DenseVectorFieldMapper.ElementType elementType, int dims) {
        this.reader = reader;
        this.field = field;
        this.elementType = elementType;
        this.dims = dims;
    }

    public FormattedDocValues getFormattedValues(DocValueFormat format) {
        final int dims = this.elementType == DenseVectorFieldMapper.ElementType.BIT ? this.dims / 8 : this.dims;
        return switch (this.elementType) {
            default -> throw new MatchException(null, null);
            case DenseVectorFieldMapper.ElementType.BYTE, DenseVectorFieldMapper.ElementType.BIT -> new FormattedDocValues(){
                private final byte[] vector;
                private BytesRef ref;
                private int numVecs;
                private final BinaryDocValues binary;
                {
                    this.vector = new byte[dims];
                    this.ref = null;
                    this.numVecs = -1;
                    try {
                        this.binary = DocValues.getBinary((LeafReader)RankVectorsDVLeafFieldData.this.reader, (String)RankVectorsDVLeafFieldData.this.field);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot load doc values", e);
                    }
                }

                public boolean advanceExact(int docId) throws IOException {
                    if (this.binary == null || !this.binary.advanceExact(docId)) {
                        return false;
                    }
                    this.ref = this.binary.binaryValue();
                    assert (this.ref.length % dims == 0);
                    this.numVecs = this.ref.length / dims;
                    return true;
                }

                public int docValueCount() {
                    return 1;
                }

                public Object nextValue() {
                    ArrayList<Byte[]> vectors = new ArrayList<Byte[]>(this.numVecs);
                    ByteRankVectorsDocValuesField.ByteVectorIterator iterator = new ByteRankVectorsDocValuesField.ByteVectorIterator(this.ref, this.vector, this.numVecs);
                    while (iterator.hasNext()) {
                        byte[] v = (byte[])iterator.next();
                        Byte[] vec = new Byte[dims];
                        for (int i = 0; i < dims; ++i) {
                            vec[i] = v[i];
                        }
                        vectors.add(vec);
                    }
                    return vectors;
                }
            };
            case DenseVectorFieldMapper.ElementType.FLOAT -> new FormattedDocValues(){
                private final float[] vector;
                private BytesRef ref;
                private int numVecs;
                private final BinaryDocValues binary;
                {
                    this.vector = new float[dims];
                    this.ref = null;
                    this.numVecs = -1;
                    try {
                        this.binary = DocValues.getBinary((LeafReader)RankVectorsDVLeafFieldData.this.reader, (String)RankVectorsDVLeafFieldData.this.field);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException("Cannot load doc values", e);
                    }
                }

                public boolean advanceExact(int docId) throws IOException {
                    if (this.binary == null || !this.binary.advanceExact(docId)) {
                        return false;
                    }
                    this.ref = this.binary.binaryValue();
                    assert (this.ref.length % (4 * dims) == 0);
                    this.numVecs = this.ref.length / (4 * dims);
                    return true;
                }

                public int docValueCount() {
                    return 1;
                }

                public Object nextValue() {
                    ArrayList<float[]> vectors = new ArrayList<float[]>(this.numVecs);
                    FloatRankVectorsDocValuesField.FloatVectorIterator iterator = new FloatRankVectorsDocValuesField.FloatVectorIterator(this.ref, this.vector, this.numVecs);
                    while (iterator.hasNext()) {
                        float[] v = (float[])iterator.next();
                        vectors.add(Arrays.copyOf(v, v.length));
                    }
                    return vectors;
                }
            };
        };
    }

    public DocValuesScriptFieldFactory getScriptFieldFactory(String name) {
        try {
            BinaryDocValues values = DocValues.getBinary((LeafReader)this.reader, (String)this.field);
            BinaryDocValues magnitudeValues = DocValues.getBinary((LeafReader)this.reader, (String)(this.field + "._magnitude"));
            return switch (this.elementType) {
                default -> throw new MatchException(null, null);
                case DenseVectorFieldMapper.ElementType.BYTE -> new ByteRankVectorsDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.FLOAT -> new FloatRankVectorsDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
                case DenseVectorFieldMapper.ElementType.BIT -> new BitRankVectorsDocValuesField(values, magnitudeValues, name, this.elementType, this.dims);
            };
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load doc values for multi-vector field!", e);
        }
    }

    public SortedBinaryDocValues getBytesValues() {
        throw new UnsupportedOperationException("String representation of doc values for multi-vector fields is not supported");
    }

    public long ramBytesUsed() {
        return 0L;
    }
}

