/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.aggs;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.InvalidAggregationPathException;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.pipeline.BucketHelpers;
import org.elasticsearch.search.aggregations.support.AggregationPath;

public final class MlAggsHelper {
    private MlAggsHelper() {
    }

    public static InvalidAggregationPathException invalidPathException(List<String> path, String aggType, String aggName) {
        return new InvalidAggregationPathException("unknown property " + String.valueOf(path) + " for " + aggType + " aggregation [" + aggName + "]");
    }

    public static Optional<DoubleBucketValues> extractDoubleBucketedValues(String bucketPath, InternalAggregations aggregations) {
        return MlAggsHelper.extractDoubleBucketedValues(bucketPath, aggregations, BucketHelpers.GapPolicy.INSERT_ZEROS, false);
    }

    public static Optional<DoubleBucketValues> extractDoubleBucketedValues(String bucketPath, InternalAggregations aggregations, BucketHelpers.GapPolicy gapPolicy, boolean excludeLastBucket) {
        List parsedPath = AggregationPath.parse((String)bucketPath).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            if (!aggregation.getName().equals(parsedPath.get(0))) continue;
            List sublistedPath = parsedPath.subList(1, parsedPath.size());
            InternalMultiBucketAggregation multiBucketsAgg = (InternalMultiBucketAggregation)aggregation;
            List buckets = multiBucketsAgg.getBuckets();
            ArrayList<Double> values = new ArrayList<Double>(buckets.size());
            ArrayList<Long> docCounts = new ArrayList<Long>(buckets.size());
            ArrayList<Integer> bucketIndexes = new ArrayList<Integer>(buckets.size());
            int bucketCount = 0;
            int totalBuckets = buckets.size();
            for (InternalMultiBucketAggregation.InternalBucket bucket : buckets) {
                Double bucketValue = BucketHelpers.resolveBucketValue((MultiBucketsAggregation)multiBucketsAgg, (InternalMultiBucketAggregation.InternalBucket)bucket, sublistedPath, (BucketHelpers.GapPolicy)gapPolicy);
                if (excludeLastBucket && bucketCount >= totalBuckets - 1) continue;
                if (bucketValue == null || Double.isNaN(bucketValue)) {
                    if (gapPolicy.isSkippable) {
                        ++bucketCount;
                        continue;
                    }
                    throw new IllegalArgumentException("missing or invalid bucket value found for path [" + bucketPath + "] in bucket [" + bucket.getKeyAsString() + "]");
                }
                bucketIndexes.add(bucketCount++);
                values.add(bucketValue);
                docCounts.add(bucket.getDocCount());
            }
            return Optional.of(new DoubleBucketValues(docCounts.stream().mapToLong(Long::longValue).toArray(), values.stream().mapToDouble(Double::doubleValue).toArray(), bucketCount == bucketIndexes.size() ? new int[]{} : bucketIndexes.stream().mapToInt(Integer::intValue).toArray()));
        }
        return Optional.empty();
    }

    public static Optional<InternalMultiBucketAggregation.InternalBucket> extractBucket(String bucketPath, InternalAggregations aggregations, int bucket) {
        List parsedPath = AggregationPath.parse((String)bucketPath).getPathElementsAsStringList();
        for (Aggregation aggregation : aggregations) {
            InternalMultiBucketAggregation multiBucketsAgg;
            List buckets;
            if (!aggregation.getName().equals(parsedPath.get(0)) || bucket >= (buckets = (multiBucketsAgg = (InternalMultiBucketAggregation)aggregation).getBuckets()).size() || bucket < 0) continue;
            return Optional.of((InternalMultiBucketAggregation.InternalBucket)buckets.get(bucket));
        }
        return Optional.empty();
    }

    public static class DoubleBucketValues {
        private final long[] docCounts;
        private final double[] values;
        private final int[] buckets;

        public DoubleBucketValues(long[] docCounts, double[] values) {
            this(docCounts, values, new int[0]);
        }

        public DoubleBucketValues(long[] docCounts, double[] values, int[] buckets) {
            this.docCounts = docCounts;
            this.values = values;
            this.buckets = buckets;
        }

        public long[] getDocCounts() {
            return this.docCounts;
        }

        public double[] getValues() {
            return this.values;
        }

        public int getBucketIndex(int bucketPos) {
            if (this.buckets.length == 0) {
                return bucketPos;
            }
            return this.buckets[bucketPos];
        }
    }
}

