/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.time.TimeProvider;
import org.elasticsearch.common.util.concurrent.FutureUtils;

class MissingReadDetector
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(MissingReadDetector.class);
    private final long interval;
    private final TimeProvider timer;
    private boolean pendingRead;
    private long lastRead;
    private ScheduledFuture<?> checker;

    MissingReadDetector(TimeProvider timer, long missingReadIntervalMillis) {
        this.interval = missingReadIntervalMillis;
        this.timer = timer;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.checker = ctx.channel().eventLoop().scheduleAtFixedRate(() -> {
            long now;
            if (!this.pendingRead && (now = this.timer.absoluteTimeInMillis()) >= this.lastRead + this.interval) {
                logger.warn("chan-id={} haven't read from channel for [{}ms]", (Object)ctx.channel().id(), (Object)(now - this.lastRead));
            }
        }, this.interval, this.interval, TimeUnit.MILLISECONDS);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.checker != null) {
            FutureUtils.cancel(this.checker);
        }
        super.handlerRemoved(ctx);
    }

    public void read(ChannelHandlerContext ctx) throws Exception {
        this.pendingRead = true;
        ctx.read();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (!ctx.channel().config().isAutoRead()) : "auto-read must be always disabled";
        this.pendingRead = false;
        this.lastRead = this.timer.absoluteTimeInMillis();
        ctx.fireChannelRead(msg);
    }
}

