/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator.topn;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.DocBlock;
import org.elasticsearch.compute.data.DocVector;
import org.elasticsearch.compute.data.IntVector;
import org.elasticsearch.compute.lucene.ShardRefCounted;
import org.elasticsearch.compute.operator.topn.ResultBuilder;
import org.elasticsearch.compute.operator.topn.TopNEncoder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;

class ResultBuilderForDoc
implements ResultBuilder {
    private final BlockFactory blockFactory;
    private final int[] shards;
    private final int[] segments;
    private final int[] docs;
    private int position;
    @Nullable
    private RefCounted nextRefCounted;
    private final Map<Integer, RefCounted> refCounted = new HashMap<Integer, RefCounted>();

    ResultBuilderForDoc(BlockFactory blockFactory, int positions) {
        this.blockFactory = blockFactory;
        this.shards = new int[positions];
        this.segments = new int[positions];
        this.docs = new int[positions];
    }

    @Override
    public void decodeKey(BytesRef keys) {
        throw new AssertionError((Object)"_doc can't be a key");
    }

    @Override
    public void setNextRefCounted(RefCounted nextRefCounted) {
        this.nextRefCounted = nextRefCounted;
        this.nextRefCounted.mustIncRef();
    }

    @Override
    public void decodeValue(BytesRef values) {
        if (this.nextRefCounted == null) {
            throw new IllegalStateException("setNextRefCounted must be set before each decodeValue call");
        }
        this.shards[this.position] = TopNEncoder.DEFAULT_UNSORTABLE.decodeInt(values);
        this.segments[this.position] = TopNEncoder.DEFAULT_UNSORTABLE.decodeInt(values);
        this.docs[this.position] = TopNEncoder.DEFAULT_UNSORTABLE.decodeInt(values);
        this.refCounted.putIfAbsent(this.shards[this.position], this.nextRefCounted);
        ++this.position;
        this.nextRefCounted = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Block build() {
        DocBlock docBlock;
        boolean success = false;
        IntVector shardsVector = null;
        IntVector segmentsVector = null;
        try {
            shardsVector = this.blockFactory.newIntArrayVector(this.shards, this.position);
            segmentsVector = this.blockFactory.newIntArrayVector(this.segments, this.position);
            IntVector docsVector = this.blockFactory.newIntArrayVector(this.docs, this.position);
            DocBlock docsBlock = new DocVector(new ShardRefCountedMap(this.refCounted), shardsVector, segmentsVector, docsVector, null).asBlock();
            success = true;
            docBlock = docsBlock;
        }
        catch (Throwable throwable) {
            this.refCounted.values().forEach(RefCounted::decRef);
            if (!success) {
                Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardsVector, segmentsVector});
            }
            throw throwable;
        }
        this.refCounted.values().forEach(RefCounted::decRef);
        if (!success) {
            Releasables.closeExpectNoException((Releasable[])new Releasable[]{shardsVector, segmentsVector});
        }
        return docBlock;
    }

    public String toString() {
        return "ValueExtractorForDoc";
    }

    public void close() {
    }

    private record ShardRefCountedMap(Map<Integer, RefCounted> refCounters) implements ShardRefCounted
    {
        @Override
        public RefCounted get(int shardId) {
            return this.refCounters.get(shardId);
        }
    }
}

