/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.operator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record DriverSleeps(Map<String, Long> counts, List<Sleep> first, List<Sleep> last) implements Writeable,
ToXContentObject
{
    static final int RECORDS = 10;

    public static DriverSleeps read(StreamInput in) throws IOException {
        if (in.getTransportVersion().before((VersionId)TransportVersions.V_8_16_0)) {
            return DriverSleeps.empty();
        }
        return new DriverSleeps(in.readImmutableMap(StreamInput::readVLong), in.readCollectionAsList(Sleep::new), in.readCollectionAsList(Sleep::new));
    }

    public void writeTo(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before((VersionId)TransportVersions.V_8_16_0)) {
            return;
        }
        out.writeMap(this.counts, StreamOutput::writeVLong);
        out.writeCollection(this.first);
        out.writeCollection(this.last);
    }

    public static DriverSleeps empty() {
        return new DriverSleeps(Map.of(), List.of(), List.of());
    }

    public DriverSleeps sleep(String reason, long now) {
        Sleep lastLast;
        if (!this.last.isEmpty() && (lastLast = this.last.get(this.last.size() - 1)).isStillSleeping()) {
            throw new IllegalStateException("Still sleeping.");
        }
        TreeMap<String, Long> newCounts = new TreeMap<String, Long>(this.counts);
        newCounts.compute(reason, (k, v) -> v == null ? 1L : v + 1L);
        List<Sleep> newFirst = this.first.size() < 10 ? this.append(this.first, reason, now) : this.first;
        List<Sleep> newLast = this.last.size() < 10 ? this.append(this.last, reason, now) : this.rollOnto(this.last, reason, now);
        return new DriverSleeps(newCounts, newFirst, newLast);
    }

    public DriverSleeps wake(long now) {
        if (now == 0L) {
            throw new IllegalStateException("Can't wake at epoch. That's used to signal sleeping.");
        }
        if (this.last.isEmpty()) {
            throw new IllegalStateException("Never slept.");
        }
        Sleep lastFirst = this.first.get(this.first.size() - 1);
        List<Sleep> newFirst = lastFirst.wake == 0L ? this.wake(this.first, now) : this.first;
        return new DriverSleeps(this.counts, newFirst, this.wake(this.last, now));
    }

    private List<Sleep> append(List<Sleep> old, String reason, long now) {
        ArrayList<Sleep> sleeps = new ArrayList<Sleep>(old.size() + 1);
        sleeps.addAll(old);
        sleeps.add(new Sleep(reason, Thread.currentThread().getName(), now, 0L));
        return Collections.unmodifiableList(sleeps);
    }

    private List<Sleep> rollOnto(List<Sleep> old, String reason, long now) {
        ArrayList<Sleep> sleeps = new ArrayList<Sleep>(old.size());
        for (int i = 1; i < old.size(); ++i) {
            sleeps.add(old.get(i));
        }
        sleeps.add(new Sleep(reason, Thread.currentThread().getName(), now, 0L));
        return Collections.unmodifiableList(sleeps);
    }

    private List<Sleep> wake(List<Sleep> old, long now) {
        ArrayList<Sleep> sleeps = new ArrayList<Sleep>(old);
        sleeps.set(sleeps.size() - 1, old.get(old.size() - 1).wake(now));
        return Collections.unmodifiableList(sleeps);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("counts");
        for (Map.Entry<String, Long> count : this.counts.entrySet()) {
            builder.field(count.getKey(), count.getValue());
        }
        builder.endObject();
        DriverSleeps.toXContent(builder, params, "first", this.first);
        DriverSleeps.toXContent(builder, params, "last", this.last);
        return builder.endObject();
    }

    private static void toXContent(XContentBuilder builder, ToXContent.Params params, String name, List<Sleep> sleeps) throws IOException {
        builder.startArray(name);
        for (Sleep sleep : sleeps) {
            sleep.toXContent(builder, params);
        }
        builder.endArray();
    }

    public record Sleep(String reason, String threadName, long sleep, long wake) implements Writeable,
    ToXContentObject
    {
        Sleep(StreamInput in) throws IOException {
            this(in.readString(), in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_THREAD_NAME_IN_DRIVER_PROFILE) ? in.readString() : "", in.readLong(), in.readLong());
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.reason);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_THREAD_NAME_IN_DRIVER_PROFILE)) {
                out.writeString(this.threadName);
            }
            out.writeLong(this.sleep);
            out.writeLong(this.wake);
        }

        Sleep wake(long now) {
            if (!this.isStillSleeping()) {
                throw new IllegalStateException("Already awake.");
            }
            return new Sleep(this.reason, Thread.currentThread().getName(), this.sleep, now);
        }

        public boolean isStillSleeping() {
            return this.wake == 0L;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("reason", this.reason);
            builder.field("thread_name", this.threadName);
            builder.timestampFieldsFromUnixEpochMillis("sleep_millis", "sleep", this.sleep);
            if (this.wake > 0L) {
                builder.timestampFieldsFromUnixEpochMillis("wake_millis", "wake", this.wake);
            }
            return builder.endObject();
        }
    }
}

