/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.lucene;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.compute.data.BlockFactory;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.lucene.DataPartitioning;
import org.elasticsearch.compute.lucene.LuceneSlice;
import org.elasticsearch.compute.lucene.LuceneSliceQueue;
import org.elasticsearch.compute.lucene.PartialLeafReaderContext;
import org.elasticsearch.compute.lucene.ShardContext;
import org.elasticsearch.compute.operator.Operator;
import org.elasticsearch.compute.operator.SourceOperator;
import org.elasticsearch.core.RefCounted;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public abstract class LuceneOperator
extends SourceOperator {
    private static final Logger logger = LogManager.getLogger(LuceneOperator.class);
    public static final int NO_LIMIT = Integer.MAX_VALUE;
    protected final List<? extends RefCounted> shardContextCounters;
    protected final BlockFactory blockFactory;
    int processedSlices;
    final int maxPageSize;
    private final LuceneSliceQueue sliceQueue;
    final Set<Query> processedQueries = new HashSet<Query>();
    final Set<String> processedShards = new HashSet<String>();
    private LuceneSlice currentSlice;
    private int sliceIndex;
    private LuceneScorer currentScorer;
    long processingNanos;
    int pagesEmitted;
    boolean doneCollecting;
    long rowsEmitted;

    protected LuceneOperator(List<? extends RefCounted> shardContextCounters, BlockFactory blockFactory, int maxPageSize, LuceneSliceQueue sliceQueue) {
        this.shardContextCounters = shardContextCounters;
        shardContextCounters.forEach(RefCounted::mustIncRef);
        this.blockFactory = blockFactory;
        this.maxPageSize = maxPageSize;
        this.sliceQueue = sliceQueue;
    }

    @Override
    public final Page getOutput() {
        try {
            Page page = this.getCheckedOutput();
            if (page != null) {
                ++this.pagesEmitted;
                this.rowsEmitted += (long)page.getPositionCount();
            }
            return page;
        }
        catch (IOException ioe) {
            throw new UncheckedIOException(ioe);
        }
    }

    protected abstract Page getCheckedOutput() throws IOException;

    @Override
    public final void close() {
        this.shardContextCounters.forEach(RefCounted::decRef);
        this.additionalClose();
    }

    protected void additionalClose() {
    }

    LuceneScorer getCurrentOrLoadNextScorer() {
        while (this.currentScorer == null || this.currentScorer.isDone()) {
            if (this.currentSlice == null || this.sliceIndex >= this.currentSlice.numLeaves()) {
                this.sliceIndex = 0;
                this.currentSlice = this.sliceQueue.nextSlice();
                if (this.currentSlice == null) {
                    this.doneCollecting = true;
                    return null;
                }
                ++this.processedSlices;
                this.processedShards.add(this.currentSlice.shardContext().shardIdentifier());
            }
            PartialLeafReaderContext partialLeaf = this.currentSlice.getLeaf(this.sliceIndex++);
            logger.trace("Starting {}", new Object[]{partialLeaf});
            LeafReaderContext leaf = partialLeaf.leafReaderContext();
            if (this.currentScorer == null || this.currentScorer.leafReaderContext() != leaf || this.currentScorer.weight != this.currentSlice.weight()) {
                Weight weight = this.currentSlice.weight();
                this.processedQueries.add(weight.getQuery());
                this.currentScorer = new LuceneScorer(this.currentSlice.shardContext(), weight, this.currentSlice.tags(), leaf);
            }
            assert (this.currentScorer.maxPosition <= partialLeaf.maxDoc()) : this.currentScorer.maxPosition + ">" + partialLeaf.maxDoc();
            this.currentScorer.maxPosition = partialLeaf.maxDoc();
            this.currentScorer.position = Math.max(this.currentScorer.position, partialLeaf.minDoc());
        }
        if (Thread.currentThread() != this.currentScorer.executingThread) {
            this.currentScorer.reinitialize();
        }
        return this.currentScorer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("shards = ").append(LuceneOperator.sortedUnion(this.processedShards, this.sliceQueue.remainingShardsIdentifiers()));
        sb.append(", maxPageSize = ").append(this.maxPageSize);
        this.describe(sb);
        sb.append("]");
        return sb.toString();
    }

    private static Set<String> sortedUnion(Collection<String> a, Collection<String> b) {
        TreeSet<String> result = new TreeSet<String>();
        result.addAll(a);
        result.addAll(b);
        return result;
    }

    protected abstract void describe(StringBuilder var1);

    @Override
    public Operator.Status status() {
        return new Status(this);
    }

    static final class LuceneScorer {
        private final ShardContext shardContext;
        private final Weight weight;
        private final LeafReaderContext leafReaderContext;
        private final List<Object> tags;
        private BulkScorer bulkScorer;
        private int position;
        private int maxPosition;
        private Thread executingThread;

        LuceneScorer(ShardContext shardContext, Weight weight, List<Object> tags, LeafReaderContext leafReaderContext) {
            this.shardContext = shardContext;
            this.weight = weight;
            this.tags = tags;
            this.leafReaderContext = leafReaderContext;
            this.reinitialize();
        }

        private void reinitialize() {
            this.executingThread = Thread.currentThread();
            try {
                this.bulkScorer = this.weight.bulkScorer(this.leafReaderContext);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        void scoreNextRange(LeafCollector collector, Bits acceptDocs, int numDocs) throws IOException {
            assert (!this.isDone()) : "scorer is exhausted";
            numDocs = Math.min(this.maxPosition - this.position, numDocs);
            assert (numDocs > 0) : "scorer was exhausted";
            this.position = this.bulkScorer.score(collector, acceptDocs, this.position, Math.min(this.maxPosition, this.position + numDocs));
        }

        LeafReaderContext leafReaderContext() {
            return this.leafReaderContext;
        }

        boolean isDone() {
            return this.bulkScorer == null || this.position >= this.maxPosition;
        }

        void markAsDone() {
            this.position = Integer.MAX_VALUE;
        }

        ShardContext shardContext() {
            return this.shardContext;
        }

        Weight weight() {
            return this.weight;
        }

        int position() {
            return this.position;
        }

        List<Object> tags() {
            return this.tags;
        }
    }

    public static class Status
    implements Operator.Status {
        public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Operator.Status.class, "lucene_source", Status::new);
        private final int processedSlices;
        private final Set<String> processedQueries;
        private final Set<String> processedShards;
        private final long processNanos;
        private final int totalSlices;
        private final int pagesEmitted;
        private final int sliceIndex;
        private final int sliceMin;
        private final int sliceMax;
        private final int current;
        private final long rowsEmitted;
        private final Map<String, LuceneSliceQueue.PartitioningStrategy> partitioningStrategies;

        protected Status(LuceneOperator operator) {
            this.processedSlices = operator.processedSlices;
            this.processedQueries = operator.processedQueries.stream().map(Query::toString).collect(Collectors.toCollection(TreeSet::new));
            this.processNanos = operator.processingNanos;
            this.processedShards = new TreeSet<String>(operator.processedShards);
            this.sliceIndex = operator.sliceIndex;
            this.totalSlices = operator.sliceQueue.totalSlices();
            LuceneSlice slice = operator.currentSlice;
            if (slice != null && this.sliceIndex < slice.numLeaves()) {
                PartialLeafReaderContext leaf = slice.getLeaf(this.sliceIndex);
                this.sliceMin = leaf.minDoc();
                this.sliceMax = leaf.maxDoc();
            } else {
                this.sliceMin = 0;
                this.sliceMax = 0;
            }
            LuceneScorer scorer = operator.currentScorer;
            this.current = scorer == null ? 0 : scorer.position;
            this.pagesEmitted = operator.pagesEmitted;
            this.rowsEmitted = operator.rowsEmitted;
            this.partitioningStrategies = operator.sliceQueue.partitioningStrategies();
        }

        Status(int processedSlices, Set<String> processedQueries, Set<String> processedShards, long processNanos, int sliceIndex, int totalSlices, int pagesEmitted, int sliceMin, int sliceMax, int current, long rowsEmitted, Map<String, LuceneSliceQueue.PartitioningStrategy> partitioningStrategies) {
            this.processedSlices = processedSlices;
            this.processedQueries = processedQueries;
            this.processedShards = processedShards;
            this.processNanos = processNanos;
            this.sliceIndex = sliceIndex;
            this.totalSlices = totalSlices;
            this.pagesEmitted = pagesEmitted;
            this.sliceMin = sliceMin;
            this.sliceMax = sliceMax;
            this.current = current;
            this.rowsEmitted = rowsEmitted;
            this.partitioningStrategies = partitioningStrategies;
        }

        Status(StreamInput in) throws IOException {
            this.processedSlices = in.readVInt();
            if (in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
                this.processedQueries = in.readCollectionAsSet(StreamInput::readString);
                this.processedShards = in.readCollectionAsSet(StreamInput::readString);
            } else {
                this.processedQueries = Collections.emptySet();
                this.processedShards = Collections.emptySet();
            }
            this.processNanos = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0) ? in.readVLong() : 0L;
            this.sliceIndex = in.readVInt();
            this.totalSlices = in.readVInt();
            this.pagesEmitted = in.readVInt();
            this.sliceMin = in.readVInt();
            this.sliceMax = in.readVInt();
            this.current = in.readVInt();
            this.rowsEmitted = in.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED) ? in.readVLong() : 0L;
            this.partitioningStrategies = Status.serializeShardPartitioning(in.getTransportVersion()) ? in.readMap(LuceneSliceQueue.PartitioningStrategy::readFrom) : Map.of();
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeVInt(this.processedSlices);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_13_0)) {
                out.writeCollection(this.processedQueries, StreamOutput::writeString);
                out.writeCollection(this.processedShards, StreamOutput::writeString);
            }
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.V_8_14_0)) {
                out.writeVLong(this.processNanos);
            }
            out.writeVInt(this.sliceIndex);
            out.writeVInt(this.totalSlices);
            out.writeVInt(this.pagesEmitted);
            out.writeVInt(this.sliceMin);
            out.writeVInt(this.sliceMax);
            out.writeVInt(this.current);
            if (out.getTransportVersion().onOrAfter((VersionId)TransportVersions.ESQL_PROFILE_ROWS_PROCESSED)) {
                out.writeVLong(this.rowsEmitted);
            }
            if (Status.serializeShardPartitioning(out.getTransportVersion())) {
                out.writeMap(this.partitioningStrategies, StreamOutput::writeString, StreamOutput::writeWriteable);
            }
        }

        private static boolean serializeShardPartitioning(TransportVersion version) {
            return version.onOrAfter((VersionId)TransportVersions.ESQL_REPORT_SHARD_PARTITIONING) || version.isPatchFrom(TransportVersions.ESQL_REPORT_SHARD_PARTITIONING_8_19);
        }

        public String getWriteableName() {
            return Status.ENTRY.name;
        }

        public int processedSlices() {
            return this.processedSlices;
        }

        public Set<String> processedQueries() {
            return this.processedQueries;
        }

        public Set<String> processedShards() {
            return this.processedShards;
        }

        public long processNanos() {
            return this.processNanos;
        }

        public int sliceIndex() {
            return this.sliceIndex;
        }

        public int totalSlices() {
            return this.totalSlices;
        }

        public int pagesEmitted() {
            return this.pagesEmitted;
        }

        public int sliceMin() {
            return this.sliceMin;
        }

        public int sliceMax() {
            return this.sliceMax;
        }

        public int current() {
            return this.current;
        }

        public long rowsEmitted() {
            return this.rowsEmitted;
        }

        public Map<String, LuceneSliceQueue.PartitioningStrategy> partitioningStrategies() {
            return this.partitioningStrategies;
        }

        @Override
        public long documentsFound() {
            return this.rowsEmitted;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            this.toXContentFields(builder, params);
            return builder.endObject();
        }

        protected void toXContentFields(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field("processed_slices", this.processedSlices);
            builder.field("processed_queries", this.processedQueries);
            builder.field("processed_shards", this.processedShards);
            builder.field("process_nanos", this.processNanos);
            if (builder.humanReadable()) {
                builder.field("process_time", (Object)TimeValue.timeValueNanos((long)this.processNanos));
            }
            builder.field("slice_index", this.sliceIndex);
            builder.field("total_slices", this.totalSlices);
            builder.field("pages_emitted", this.pagesEmitted);
            builder.field("slice_min", this.sliceMin);
            builder.field("slice_max", this.sliceMax);
            builder.field("current", this.current);
            builder.field("rows_emitted", this.rowsEmitted);
            builder.field("partitioning_strategies", new TreeMap<String, LuceneSliceQueue.PartitioningStrategy>(this.partitioningStrategies));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.processedSlices == status.processedSlices && this.processedQueries.equals(status.processedQueries) && this.processedShards.equals(status.processedShards) && this.processNanos == status.processNanos && this.sliceIndex == status.sliceIndex && this.totalSlices == status.totalSlices && this.pagesEmitted == status.pagesEmitted && this.sliceMin == status.sliceMin && this.sliceMax == status.sliceMax && this.current == status.current && this.rowsEmitted == status.rowsEmitted && this.partitioningStrategies.equals(status.partitioningStrategies);
        }

        public int hashCode() {
            return Objects.hash(this.processedSlices, this.sliceIndex, this.totalSlices, this.pagesEmitted, this.sliceMin, this.sliceMax, this.current, this.rowsEmitted, this.partitioningStrategies);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.V_8_11_X;
        }
    }

    public static abstract class Factory
    implements SourceOperator.SourceOperatorFactory {
        protected final DataPartitioning dataPartitioning;
        protected final int taskConcurrency;
        protected final int limit;
        protected final boolean needsScore;
        protected final LuceneSliceQueue sliceQueue;

        protected Factory(List<? extends ShardContext> contexts, Function<ShardContext, List<LuceneSliceQueue.QueryAndTags>> queryFunction, DataPartitioning dataPartitioning, Function<Query, LuceneSliceQueue.PartitioningStrategy> autoStrategy, int taskConcurrency, int limit, boolean needsScore, Function<ShardContext, ScoreMode> scoreModeFunction) {
            this.limit = limit;
            this.dataPartitioning = dataPartitioning;
            this.sliceQueue = LuceneSliceQueue.create(contexts, queryFunction, dataPartitioning, autoStrategy, taskConcurrency, scoreModeFunction);
            this.taskConcurrency = Math.min(this.sliceQueue.totalSlices(), taskConcurrency);
            this.needsScore = needsScore;
        }

        public final int taskConcurrency() {
            return this.taskConcurrency;
        }

        public final int limit() {
            return this.limit;
        }
    }
}

