/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.compute.aggregation;

import java.util.List;
import org.elasticsearch.compute.aggregation.AggregatorFunction;
import org.elasticsearch.compute.aggregation.IntermediateStateDesc;
import org.elasticsearch.compute.aggregation.LongState;
import org.elasticsearch.compute.aggregation.MaxLongAggregator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.BooleanBlock;
import org.elasticsearch.compute.data.BooleanVector;
import org.elasticsearch.compute.data.ElementType;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;

public final class MaxLongAggregatorFunction
implements AggregatorFunction {
    private static final List<IntermediateStateDesc> INTERMEDIATE_STATE_DESC = List.of(new IntermediateStateDesc("max", ElementType.LONG), new IntermediateStateDesc("seen", ElementType.BOOLEAN));
    private final DriverContext driverContext;
    private final LongState state;
    private final List<Integer> channels;

    public MaxLongAggregatorFunction(DriverContext driverContext, List<Integer> channels, LongState state) {
        this.driverContext = driverContext;
        this.channels = channels;
        this.state = state;
    }

    public static MaxLongAggregatorFunction create(DriverContext driverContext, List<Integer> channels) {
        return new MaxLongAggregatorFunction(driverContext, channels, new LongState(MaxLongAggregator.init()));
    }

    public static List<IntermediateStateDesc> intermediateStateDesc() {
        return INTERMEDIATE_STATE_DESC;
    }

    @Override
    public int intermediateBlockCount() {
        return INTERMEDIATE_STATE_DESC.size();
    }

    @Override
    public void addRawInput(Page page, BooleanVector mask) {
        if (mask.allFalse()) {
            return;
        }
        if (mask.allTrue()) {
            LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
            LongVector vector = block.asVector();
            if (vector != null) {
                this.addRawVector(vector);
            } else {
                this.addRawBlock(block);
            }
            return;
        }
        LongBlock block = (LongBlock)page.getBlock(this.channels.get(0));
        LongVector vector = block.asVector();
        if (vector != null) {
            this.addRawVector(vector, mask);
        } else {
            this.addRawBlock(block, mask);
        }
    }

    private void addRawVector(LongVector vector) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            this.state.longValue(MaxLongAggregator.combine(this.state.longValue(), vector.getLong(i)));
        }
    }

    private void addRawVector(LongVector vector, BooleanVector mask) {
        this.state.seen(true);
        for (int i = 0; i < vector.getPositionCount(); ++i) {
            if (!mask.getBoolean(i)) continue;
            this.state.longValue(MaxLongAggregator.combine(this.state.longValue(), vector.getLong(i)));
        }
    }

    private void addRawBlock(LongBlock block) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                this.state.longValue(MaxLongAggregator.combine(this.state.longValue(), block.getLong(i)));
            }
        }
    }

    private void addRawBlock(LongBlock block, BooleanVector mask) {
        for (int p = 0; p < block.getPositionCount(); ++p) {
            if (!mask.getBoolean(p) || block.isNull(p)) continue;
            this.state.seen(true);
            int start = block.getFirstValueIndex(p);
            int end = start + block.getValueCount(p);
            for (int i = start; i < end; ++i) {
                this.state.longValue(MaxLongAggregator.combine(this.state.longValue(), block.getLong(i)));
            }
        }
    }

    @Override
    public void addIntermediateInput(Page page) {
        assert (this.channels.size() == this.intermediateBlockCount());
        assert (page.getBlockCount() >= this.channels.get(0) + MaxLongAggregatorFunction.intermediateStateDesc().size());
        Object maxUncast = page.getBlock(this.channels.get(0));
        if (maxUncast.areAllValuesNull()) {
            return;
        }
        LongVector max = ((LongBlock)maxUncast).asVector();
        assert (max.getPositionCount() == 1);
        Object seenUncast = page.getBlock(this.channels.get(1));
        if (seenUncast.areAllValuesNull()) {
            return;
        }
        BooleanVector seen = ((BooleanBlock)seenUncast).asVector();
        assert (seen.getPositionCount() == 1);
        if (seen.getBoolean(0)) {
            this.state.longValue(MaxLongAggregator.combine(this.state.longValue(), max.getLong(0)));
            this.state.seen(true);
        }
    }

    @Override
    public void evaluateIntermediate(Block[] blocks, int offset, DriverContext driverContext) {
        this.state.toIntermediate(blocks, offset, driverContext);
    }

    @Override
    public void evaluateFinal(Block[] blocks, int offset, DriverContext driverContext) {
        if (!this.state.seen()) {
            blocks[offset] = driverContext.blockFactory().newConstantNullBlock(1);
            return;
        }
        blocks[offset] = driverContext.blockFactory().newConstantLongBlockWith(this.state.longValue(), 1);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName()).append("[");
        sb.append("channels=").append(this.channels);
        sb.append("]");
        return sb.toString();
    }

    public void close() {
        this.state.close();
    }
}

