/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.xpack.profiling.action.SubGroup;
import org.elasticsearch.xpack.profiling.action.TraceEvent;

public final class SubGroupCollector {
    static final String CUSTOM_EVENT_SUB_AGGREGATION_NAME = "custom_event_group_";
    private static final Logger log = LogManager.getLogger(SubGroupCollector.class);
    private final String[] aggregationFields;

    public static SubGroupCollector attach(AbstractAggregationBuilder<?> parentAggregation, String[] aggregationFields) {
        SubGroupCollector c = new SubGroupCollector(aggregationFields);
        c.addAggregations(parentAggregation);
        return c;
    }

    private SubGroupCollector(String[] aggregationFields) {
        this.aggregationFields = aggregationFields;
    }

    private boolean hasAggregationFields() {
        return this.aggregationFields != null && this.aggregationFields.length > 0;
    }

    private void addAggregations(AbstractAggregationBuilder<?> parentAggregation) {
        if (this.hasAggregationFields()) {
            log.trace("Grouping stacktrace events by {}.", (Object)this.aggregationFields);
            TermsAggregationBuilder parentAgg = parentAggregation;
            for (String aggregationField : this.aggregationFields) {
                String aggName = CUSTOM_EVENT_SUB_AGGREGATION_NAME + aggregationField;
                TermsAggregationBuilder agg = (TermsAggregationBuilder)new TermsAggregationBuilder(aggName).field(aggregationField);
                parentAgg.subAggregation((AggregationBuilder)agg);
                parentAgg = agg;
            }
        }
    }

    void collectResults(MultiBucketsAggregation.Bucket bucket, TraceEvent event) {
        this.collectResults(new BucketAdapter(bucket), event);
    }

    void collectResults(Bucket bucket, TraceEvent event) {
        if (this.hasAggregationFields()) {
            if (event.subGroups == null) {
                event.subGroups = SubGroup.root(this.aggregationFields[0]);
            }
            this.collectInternal(bucket.getAggregations(), event.subGroups, 0);
        }
    }

    private void collectInternal(Agg parentAgg, SubGroup parentGroup, int aggField) {
        if (aggField == this.aggregationFields.length) {
            return;
        }
        String aggName = CUSTOM_EVENT_SUB_AGGREGATION_NAME + this.aggregationFields[aggField];
        for (Bucket b : parentAgg.getBuckets(aggName)) {
            String subGroupName = b.getKey();
            parentGroup.addCount(subGroupName, b.getCount());
            SubGroup currentGroup = parentGroup.getSubGroup(subGroupName);
            int nextAggField = aggField + 1;
            if (nextAggField >= this.aggregationFields.length) continue;
            this.collectInternal(b.getAggregations(), currentGroup.getOrAddChild(this.aggregationFields[nextAggField]), nextAggField);
        }
    }

    static class BucketAdapter
    implements Bucket {
        private final MultiBucketsAggregation.Bucket bucket;

        BucketAdapter(MultiBucketsAggregation.Bucket bucket) {
            this.bucket = bucket;
        }

        @Override
        public String getKey() {
            return this.bucket.getKeyAsString();
        }

        @Override
        public long getCount() {
            return this.bucket.getDocCount();
        }

        @Override
        public Agg getAggregations() {
            return new InternalAggregationAdapter(this.bucket.getAggregations());
        }
    }

    static interface Bucket {
        public String getKey();

        public long getCount();

        public Agg getAggregations();
    }

    static interface Agg {
        public Iterable<Bucket> getBuckets(String var1);
    }

    static class InternalAggregationAdapter
    implements Agg {
        private final InternalAggregations agg;

        InternalAggregationAdapter(InternalAggregations agg) {
            this.agg = agg;
        }

        @Override
        public Iterable<Bucket> getBuckets(String aggName) {
            MultiBucketsAggregation multiBucketsAggregation = (MultiBucketsAggregation)this.agg.get(aggName);
            return () -> {
                final Iterator it = multiBucketsAggregation.getBuckets().iterator();
                return new Iterator<Bucket>(this){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Bucket next() {
                        return new BucketAdapter((MultiBucketsAggregation.Bucket)it.next());
                    }
                };
            };
        }
    }
}

