/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.profiling.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xpack.profiling.action.CostEntry;
import org.elasticsearch.xpack.profiling.action.InstanceType;
import org.elasticsearch.xpack.profiling.action.StopWatch;

public final class InstanceTypeService {
    private static final Logger log = LogManager.getLogger(InstanceTypeService.class);

    private InstanceTypeService() {
    }

    public static CostEntry getCosts(InstanceType instance) {
        return Holder.COSTS_PER_DATACENTER.get(instance);
    }

    private static final class Holder {
        private static final Map<InstanceType, CostEntry> COSTS_PER_DATACENTER;

        private Holder() {
        }

        static {
            StopWatch watch = new StopWatch("loadProfilingCostsData");
            HashMap<InstanceType, CostEntry> tmp = new HashMap<InstanceType, CostEntry>();
            HashMap objects = new HashMap();
            Function<String, String> dedupString = s -> (String)objects.computeIfAbsent((CostEntry)s, Function.identity());
            for (String provider : List.of("aws", "azure")) {
                String name = "profiling-costs-" + provider + ".json.gz";
                try (GZIPInputStream in = new GZIPInputStream(InstanceTypeService.class.getClassLoader().getResourceAsStream(name));){
                    XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, (InputStream)in);
                    try {
                        if (parser.currentToken() == null) {
                            parser.nextToken();
                        }
                        List rawData = XContentParserUtils.parseList((XContentParser)parser, XContentParser::map);
                        for (Map entry : rawData) {
                            tmp.put(new InstanceType(provider, dedupString.apply((String)entry.get("region")), dedupString.apply((String)entry.get("instance_type"))), (CostEntry)objects.computeIfAbsent(CostEntry.fromSource(entry), Function.identity()));
                        }
                    }
                    finally {
                        if (parser == null) continue;
                        parser.close();
                    }
                }
                catch (IOException e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
            COSTS_PER_DATACENTER = Map.copyOf(tmp);
            log.debug(watch::report);
        }
    }
}

