/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.ssl;

import java.nio.file.Path;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.X509ExtendedKeyManager;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.ssl.StoredCertificate;
import org.elasticsearch.core.Tuple;

public interface SslKeyConfig {
    public Collection<Path> getDependentFiles();

    public X509ExtendedKeyManager createKeyManager();

    public List<Tuple<PrivateKey, X509Certificate>> getKeys();

    public Collection<StoredCertificate> getConfiguredCertificates();

    default public boolean hasKeyMaterial() {
        return !this.getKeys().isEmpty();
    }

    default public SslTrustConfig asTrustConfig() {
        return null;
    }
}

