/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.core.async.AsyncTaskMaintenanceService;
import org.elasticsearch.xpack.core.search.action.GetAsyncSearchAction;
import org.elasticsearch.xpack.core.search.action.GetAsyncStatusAction;
import org.elasticsearch.xpack.core.search.action.SubmitAsyncSearchAction;
import org.elasticsearch.xpack.search.RestDeleteAsyncSearchAction;
import org.elasticsearch.xpack.search.RestGetAsyncSearchAction;
import org.elasticsearch.xpack.search.RestGetAsyncStatusAction;
import org.elasticsearch.xpack.search.RestSubmitAsyncSearchAction;
import org.elasticsearch.xpack.search.TransportGetAsyncSearchAction;
import org.elasticsearch.xpack.search.TransportGetAsyncStatusAction;
import org.elasticsearch.xpack.search.TransportSubmitAsyncSearchAction;

public final class AsyncSearch
extends Plugin
implements ActionPlugin {
    public List<ActionPlugin.ActionHandler> getActions() {
        return Arrays.asList(new ActionPlugin.ActionHandler((ActionType)SubmitAsyncSearchAction.INSTANCE, TransportSubmitAsyncSearchAction.class), new ActionPlugin.ActionHandler((ActionType)GetAsyncSearchAction.INSTANCE, TransportGetAsyncSearchAction.class), new ActionPlugin.ActionHandler((ActionType)GetAsyncStatusAction.INSTANCE, TransportGetAsyncStatusAction.class));
    }

    public List<RestHandler> getRestHandlers(Settings settings, NamedWriteableRegistry namedWriteableRegistry, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster, Predicate<NodeFeature> clusterSupportsFeature) {
        return Arrays.asList(new RestHandler[]{new RestSubmitAsyncSearchAction(restController.getSearchUsageHolder(), clusterSupportsFeature), new RestGetAsyncSearchAction(), new RestGetAsyncStatusAction(), new RestDeleteAsyncSearchAction()});
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(AsyncTaskMaintenanceService.ASYNC_SEARCH_CLEANUP_INTERVAL_SETTING);
    }
}

