/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.stats;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.search.aggregations.metrics.Stats;

public class StatsAccumulator
implements Writeable {
    private long count;
    private double total;
    private Double min;
    private Double max;

    public StatsAccumulator() {
    }

    public StatsAccumulator(StreamInput in) throws IOException {
        this.count = in.readLong();
        this.total = in.readDouble();
        this.min = in.readOptionalDouble();
        this.max = in.readOptionalDouble();
    }

    private StatsAccumulator(long count, double total, double min, double max) {
        this.count = count;
        this.total = total;
        this.min = min;
        this.max = max;
    }

    public void add(double value) {
        ++this.count;
        this.total += value;
        this.min = this.min == null ? value : (value < this.min ? value : this.min);
        this.max = this.max == null ? value : (value > this.max ? value : this.max);
    }

    public double getMin() {
        return this.min == null ? 0.0 : this.min;
    }

    public double getMax() {
        return this.max == null ? 0.0 : this.max;
    }

    public double getAvg() {
        return (double)this.count == 0.0 ? 0.0 : this.total / (double)this.count;
    }

    public double getTotal() {
        return this.total;
    }

    public void merge(StatsAccumulator other) {
        this.count += other.count;
        this.total += other.total;
        Double d = this.min == null ? other.min : (other.min == null ? this.min : (this.min = other.min < this.min ? other.min : this.min));
        this.max = this.max == null ? other.max : (other.max == null ? this.max : (other.max > this.max ? other.max : this.max));
    }

    public Map<String, Double> asMap() {
        HashMap<String, Double> map = new HashMap<String, Double>();
        map.put("min", this.getMin());
        map.put("max", this.getMax());
        map.put("avg", this.getAvg());
        map.put("total", this.getTotal());
        return map;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.count);
        out.writeDouble(this.total);
        out.writeOptionalDouble(this.min);
        out.writeOptionalDouble(this.max);
    }

    public static StatsAccumulator fromStatsAggregation(Stats statsAggregation) {
        return new StatsAccumulator(statsAggregation.getCount(), statsAggregation.getSum(), statsAggregation.getMin(), statsAggregation.getMax());
    }

    public int hashCode() {
        return Objects.hash(this.count, this.total, this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatsAccumulator other = (StatsAccumulator)obj;
        return Objects.equals(this.count, other.count) && Objects.equals(this.total, other.total) && Objects.equals(this.min, other.min) && Objects.equals(this.max, other.max);
    }

    public static class Fields {
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String AVG = "avg";
        public static final String TOTAL = "total";
    }
}

