/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent;

import java.nio.ByteBuffer;
import java.util.Arrays;

public interface XContentString {
    public String string();

    public UTF8Bytes bytes();

    public int stringLength();

    public record UTF8Bytes(byte[] bytes, int offset, int length) implements Comparable<UTF8Bytes>
    {
        public UTF8Bytes(byte[] bytes) {
            this(bytes, 0, bytes.length);
        }

        @Override
        public int compareTo(UTF8Bytes o) {
            if (this.bytes == o.bytes && this.offset == o.offset && this.length == o.length) {
                return 0;
            }
            return Arrays.compareUnsigned(this.bytes, this.offset, this.offset + this.length, o.bytes, o.offset, o.offset + o.length);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((UTF8Bytes)o) == 0;
        }

        @Override
        public int hashCode() {
            return ByteBuffer.wrap(this.bytes, this.offset, this.length).hashCode();
        }
    }
}

