/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate.operator.comparison;

import java.math.BigInteger;
import java.util.Set;
import org.elasticsearch.xpack.ql.expression.predicate.operator.arithmetic.Arithmetics;
import org.elasticsearch.xpack.versionfield.Version;

public final class Comparisons {
    private Comparisons() {
    }

    public static Boolean eq(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i == 0);
    }

    public static boolean nulleq(Object l, Object r) {
        if (l == null && r == null) {
            return true;
        }
        Integer i = Comparisons.compare(l, r);
        return i == null ? false : i == 0;
    }

    static Boolean neq(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i != 0);
    }

    public static Boolean lt(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i < 0);
    }

    static Boolean lte(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i <= 0);
    }

    public static Boolean gt(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i > 0);
    }

    static Boolean gte(Object l, Object r) {
        Integer i = Comparisons.compare(l, r);
        return i == null ? null : Boolean.valueOf(i >= 0);
    }

    static Boolean in(Object l, Set<Object> r) {
        return r.contains(l);
    }

    static Integer compare(Object l, Object r) {
        if (l == null || r == null) {
            return null;
        }
        if (l instanceof Number) {
            Number lN = (Number)l;
            if (r instanceof Number) {
                Number rN = (Number)r;
                return Comparisons.compare(lN, rN);
            }
        }
        if (l instanceof Version) {
            Version lV = (Version)l;
            if (r instanceof String) {
                String rStr = (String)r;
                return lV.compareTo(new Version(rStr));
            }
        }
        if (l instanceof String) {
            String lStr = (String)l;
            if (r instanceof Version) {
                Version rV = (Version)r;
                return new Version(lStr).compareTo(rV);
            }
        }
        if (l instanceof Comparable) {
            Comparable lC = (Comparable)l;
            if (r instanceof Comparable) {
                try {
                    return lC.compareTo(r);
                }
                catch (ClassCastException cce) {
                    return null;
                }
            }
        }
        return null;
    }

    private static Integer compare(Number l, Number r) {
        if (l instanceof Double || r instanceof Double) {
            return Double.compare(l.doubleValue(), r.doubleValue());
        }
        if (l instanceof Float || r instanceof Float) {
            return Float.compare(l.floatValue(), r.floatValue());
        }
        if (l instanceof BigInteger || r instanceof BigInteger) {
            return Arithmetics.asBigInteger(l).compareTo(Arithmetics.asBigInteger(r));
        }
        if (l instanceof Long || r instanceof Long) {
            return Long.compare(l.longValue(), r.longValue());
        }
        return Integer.compare(l.intValue(), r.intValue());
    }
}

