/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.SubscribableListener;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.OriginSettingClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ml.utils.MlIndexAndAlias;
import org.elasticsearch.xpack.ml.MachineLearning;
import org.elasticsearch.xpack.ml.MlAutoUpdateService;

public class MlIndexRollover
implements MlAutoUpdateService.UpdateAction {
    private static final Logger logger = LogManager.getLogger(MlIndexRollover.class);
    private final IndexNameExpressionResolver expressionResolver;
    private final OriginSettingClient client;
    private final List<IndexPatternAndAlias> indicesToRollover;

    public MlIndexRollover(List<IndexPatternAndAlias> indicesToRollover, IndexNameExpressionResolver expressionResolver, Client client) {
        this.expressionResolver = expressionResolver;
        this.client = new OriginSettingClient(client, "ml");
        this.indicesToRollover = indicesToRollover;
    }

    @Override
    public boolean isMinTransportVersionSupported(TransportVersion minTransportVersion) {
        return minTransportVersion.supports(TransportVersions.ML_ROLLOVER_LEGACY_INDICES);
    }

    @Override
    public boolean isAbleToRun(ClusterState latestState) {
        for (IndexPatternAndAlias indexPatternAndAlias : this.indicesToRollover) {
            String[] indices = this.expressionResolver.concreteIndexNames(latestState, IndicesOptions.lenientExpandOpenHidden(), new String[]{indexPatternAndAlias.indexPattern});
            if (indices.length == 0) continue;
            String latestIndex = MlIndexAndAlias.latestIndex((String[])indices);
            IndexRoutingTable routingTable = latestState.getRoutingTable().index(latestIndex);
            if (routingTable != null && routingTable.allPrimaryShardsActive()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getName() {
        return "ml_legacy_index_rollover";
    }

    @Override
    public void runUpdate(ClusterState latestState) {
        ArrayList<ElasticsearchStatusException> failures = new ArrayList<ElasticsearchStatusException>();
        for (IndexPatternAndAlias indexPatternAndAlias : this.indicesToRollover) {
            PlainActionFuture rolloverIndices = new PlainActionFuture();
            this.rolloverLegacyIndices(latestState, indexPatternAndAlias.indexPattern(), indexPatternAndAlias.alias(), (ActionListener<Boolean>)rolloverIndices);
            try {
                rolloverIndices.actionGet();
            }
            catch (Exception ex) {
                logger.warn(() -> "failed rolling over legacy index [" + indexPatternAndAlias.indexPattern() + "]", (Throwable)ex);
                if (ex instanceof ElasticsearchException) {
                    ElasticsearchException elasticsearchException = (ElasticsearchException)ex;
                    failures.add(new ElasticsearchStatusException("Failed rollover", elasticsearchException.status(), (Throwable)elasticsearchException, new Object[0]));
                    break;
                }
                failures.add(new ElasticsearchStatusException("Failed rollover", RestStatus.REQUEST_TIMEOUT, (Throwable)ex, new Object[0]));
                break;
            }
        }
        if (failures.isEmpty()) {
            logger.info("ML legacy indices rolled over");
            return;
        }
        ElasticsearchException exception = new ElasticsearchException("some error", new Object[0]);
        failures.forEach(arg_0 -> exception.addSuppressed(arg_0));
        throw exception;
    }

    private void rolloverLegacyIndices(ClusterState clusterState, String indexPattern, String alias, ActionListener<Boolean> listener) {
        String[] concreteIndices = this.expressionResolver.concreteIndexNames(clusterState, IndicesOptions.LENIENT_EXPAND_OPEN_CLOSED, new String[]{indexPattern});
        if (concreteIndices.length == 0) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        String latestIndex = MlIndexAndAlias.latestIndex((String[])concreteIndices);
        boolean isCompatibleIndexVersion = MlIndexAndAlias.indexIsReadWriteCompatibleInV9((IndexVersion)clusterState.metadata().getProject().index(latestIndex).getCreationVersion());
        boolean hasAlias = clusterState.getMetadata().getProject().hasAlias(alias);
        if (isCompatibleIndexVersion && hasAlias) {
            listener.onResponse((Object)Boolean.FALSE);
            return;
        }
        SubscribableListener.newForked(l -> {
            if (!hasAlias) {
                MlIndexAndAlias.updateWriteAlias((Client)this.client, (String)alias, null, (String)latestIndex, (TimeValue)MachineLearning.HARD_CODED_MACHINE_LEARNING_MASTER_NODE_TIMEOUT, (ActionListener)l);
            } else {
                l.onResponse((Object)Boolean.TRUE);
            }
        }).andThen((l, success) -> {
            if (!isCompatibleIndexVersion) {
                logger.info("rolling over legacy index [{}] with alias [{}]", new Object[]{latestIndex, alias});
                this.rollover(alias, (ActionListener<Boolean>)l);
            } else {
                l.onResponse((Object)Boolean.TRUE);
            }
        }).addListener(listener);
    }

    private void rollover(String alias, ActionListener<Boolean> listener) {
        this.client.admin().indices().rolloverIndex(new RolloverRequest(alias, null), listener.delegateFailure((l, response) -> l.onResponse((Object)Boolean.TRUE)));
    }

    static boolean isCompatibleIndexVersion(IndexVersion version) {
        return version.onOrAfter((VersionId)IndexVersions.MINIMUM_COMPATIBLE);
    }

    public record IndexPatternAndAlias(String indexPattern, String alias) {
    }
}

