/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.physical;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.xpack.esql.core.expression.Alias;
import org.elasticsearch.xpack.esql.core.expression.Attribute;
import org.elasticsearch.xpack.esql.core.expression.AttributeSet;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.Expressions;
import org.elasticsearch.xpack.esql.core.expression.Literal;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.util.Holder;
import org.elasticsearch.xpack.esql.plan.logical.Aggregate;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.plan.logical.Project;
import org.elasticsearch.xpack.esql.plan.physical.ExchangeExec;
import org.elasticsearch.xpack.esql.plan.physical.FragmentExec;
import org.elasticsearch.xpack.esql.plan.physical.MergeExec;
import org.elasticsearch.xpack.esql.plan.physical.PhysicalPlan;
import org.elasticsearch.xpack.esql.rule.Rule;

public class ProjectAwayColumns
extends Rule<PhysicalPlan, PhysicalPlan> {
    @Override
    public PhysicalPlan apply(PhysicalPlan plan) {
        Holder keepTraversing = new Holder((Object)Boolean.TRUE);
        AttributeSet.Builder requiredAttrBuilder = plan.outputSet().asBuilder();
        return (PhysicalPlan)plan.transformDown(currentPlanNode -> {
            if (!((Boolean)keepTraversing.get()).booleanValue()) {
                return currentPlanNode;
            }
            if (currentPlanNode instanceof MergeExec) {
                MergeExec mergeExec = (MergeExec)((Object)currentPlanNode);
                keepTraversing.set((Object)Boolean.FALSE);
                ArrayList<PhysicalPlan> newChildren = new ArrayList<PhysicalPlan>();
                boolean changed = false;
                for (PhysicalPlan child : mergeExec.children()) {
                    PhysicalPlan newChild = this.apply(child);
                    if (newChild != child) {
                        changed = true;
                    }
                    newChildren.add(newChild);
                }
                return changed ? new MergeExec(mergeExec.source(), newChildren, mergeExec.output()) : mergeExec;
            }
            if (currentPlanNode instanceof ExchangeExec) {
                FragmentExec fragmentExec;
                LogicalPlan logicalFragment;
                ExchangeExec exec = (ExchangeExec)((Object)currentPlanNode);
                keepTraversing.set((Object)Boolean.FALSE);
                PhysicalPlan child = exec.child();
                if (child instanceof FragmentExec && !((logicalFragment = (fragmentExec = (FragmentExec)child).fragment()) instanceof Aggregate)) {
                    List<Object> output = new ArrayList<Attribute>();
                    for (Attribute attribute : logicalFragment.output()) {
                        if (!requiredAttrBuilder.contains((Object)attribute)) continue;
                        output.add(attribute);
                        requiredAttrBuilder.remove((Object)attribute);
                    }
                    output.addAll((Collection<Attribute>)requiredAttrBuilder.build());
                    if (output.isEmpty()) {
                        Alias alias = new Alias(logicalFragment.source(), "<all-fields-projected>", (Expression)Literal.NULL, null, true);
                        List<Alias> fields = Collections.singletonList(alias);
                        logicalFragment = new Eval(logicalFragment.source(), logicalFragment, fields);
                        output = Expressions.asAttributes(fields);
                    }
                    FragmentExec newChild = new FragmentExec(Source.EMPTY, new Project(logicalFragment.source(), logicalFragment, output), fragmentExec.esFilter(), fragmentExec.estimatedRowSize());
                    return new ExchangeExec(exec.source(), output, exec.inBetweenAggs(), newChild);
                }
            } else {
                AttributeSet.Builder addedAttrBuilder = currentPlanNode.outputSet().asBuilder();
                addedAttrBuilder.removeIf(arg_0 -> ((AttributeSet)currentPlanNode.inputSet()).contains(arg_0));
                requiredAttrBuilder.removeIf(arg_0 -> ((AttributeSet.Builder)addedAttrBuilder).contains(arg_0));
                requiredAttrBuilder.addAll(currentPlanNode.references());
            }
            return currentPlanNode;
        });
    }
}

