/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.optimizer.rules.logical;

import org.elasticsearch.xpack.esql.core.expression.AttributeMap;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.ReferenceAttribute;
import org.elasticsearch.xpack.esql.optimizer.LogicalOptimizerContext;
import org.elasticsearch.xpack.esql.optimizer.rules.RuleUtils;
import org.elasticsearch.xpack.esql.plan.logical.Eval;
import org.elasticsearch.xpack.esql.plan.logical.Filter;
import org.elasticsearch.xpack.esql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.esql.rule.ParameterizedRule;

public final class PropagateEvalFoldables
extends ParameterizedRule<LogicalPlan, LogicalPlan, LogicalOptimizerContext> {
    @Override
    public LogicalPlan apply(LogicalPlan plan, LogicalOptimizerContext ctx) {
        AttributeMap<Expression> collectRefs = RuleUtils.foldableReferences(plan, ctx);
        if (collectRefs.isEmpty()) {
            return plan;
        }
        plan = (LogicalPlan)plan.transformUp(p -> {
            if (p instanceof Filter || p instanceof Eval) {
                p = (LogicalPlan)((Object)((Object)p.transformExpressionsOnly(ReferenceAttribute.class, r -> (Expression)collectRefs.resolve(r, r))));
            }
            return p;
        });
        return plan;
    }
}

