/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.predicate.operator.comparison;

import java.time.ZoneId;
import java.util.Map;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.xpack.esql.core.expression.Expression;
import org.elasticsearch.xpack.esql.core.expression.predicate.Negatable;
import org.elasticsearch.xpack.esql.core.tree.Node;
import org.elasticsearch.xpack.esql.core.tree.NodeInfo;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.core.type.DataType;
import org.elasticsearch.xpack.esql.expression.function.FunctionInfo;
import org.elasticsearch.xpack.esql.expression.function.Param;
import org.elasticsearch.xpack.esql.expression.predicate.operator.arithmetic.EsqlArithmeticOperation;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.EsqlBinaryComparison;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsBoolsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsDoublesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsGeometriesEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsIntsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsKeywordsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsLongsEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsMillisNanosEvaluator;
import org.elasticsearch.xpack.esql.expression.predicate.operator.comparison.NotEqualsNanosMillisEvaluator;

public class NotEquals
extends EsqlBinaryComparison
implements Negatable<EsqlBinaryComparison> {
    public static final NamedWriteableRegistry.Entry ENTRY = new NamedWriteableRegistry.Entry(Expression.class, "NotEquals", EsqlBinaryComparison::readFrom);
    private static final Map<DataType, EsqlArithmeticOperation.BinaryEvaluator> evaluatorMap = Map.ofEntries(Map.entry(DataType.BOOLEAN, NotEqualsBoolsEvaluator.Factory::new), Map.entry(DataType.INTEGER, NotEqualsIntsEvaluator.Factory::new), Map.entry(DataType.DOUBLE, NotEqualsDoublesEvaluator.Factory::new), Map.entry(DataType.LONG, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataType.UNSIGNED_LONG, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataType.DATETIME, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataType.DATE_NANOS, NotEqualsLongsEvaluator.Factory::new), Map.entry(DataType.GEO_POINT, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_POINT, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.GEO_SHAPE, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.CARTESIAN_SHAPE, NotEqualsGeometriesEvaluator.Factory::new), Map.entry(DataType.KEYWORD, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.TEXT, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.VERSION, NotEqualsKeywordsEvaluator.Factory::new), Map.entry(DataType.IP, NotEqualsKeywordsEvaluator.Factory::new));

    @FunctionInfo(operator="!=", returnType={"boolean"}, description="Check if two fields are unequal. If either field is <<esql-multivalued-fields,multivalued>> then the result is `null`.", note="This is pushed to the underlying search index if one side of the comparison is constant and the other side is a field in the index that has both an <<mapping-index>> and <<doc-values>>.")
    public NotEquals(Source source, @Param(name="lhs", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression left, @Param(name="rhs", type={"boolean", "cartesian_point", "cartesian_shape", "date", "double", "geo_point", "geo_shape", "integer", "ip", "keyword", "long", "text", "unsigned_long", "version"}, description="An expression.") Expression right) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.NEQ, evaluatorMap, NotEqualsNanosMillisEvaluator.Factory::new, NotEqualsMillisNanosEvaluator.Factory::new);
    }

    public NotEquals(Source source, Expression left, Expression right, ZoneId zoneId) {
        super(source, left, right, EsqlBinaryComparison.BinaryComparisonOperation.NEQ, zoneId, evaluatorMap, NotEqualsNanosMillisEvaluator.Factory::new, NotEqualsMillisNanosEvaluator.Factory::new);
    }

    public String getWriteableName() {
        return NotEquals.ENTRY.name;
    }

    static boolean processInts(int lhs, int rhs) {
        return lhs != rhs;
    }

    static boolean processLongs(long lhs, long rhs) {
        return lhs != rhs;
    }

    static boolean processMillisNanos(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)rhs, (long)lhs) != 0;
    }

    static boolean processNanosMillis(long lhs, long rhs) {
        return DateUtils.compareNanosToMillis((long)lhs, (long)rhs) != 0;
    }

    static boolean processDoubles(double lhs, double rhs) {
        return lhs != rhs;
    }

    static boolean processKeywords(BytesRef lhs, BytesRef rhs) {
        return false == lhs.equals((Object)rhs);
    }

    static boolean processBools(boolean lhs, boolean rhs) {
        return lhs != rhs;
    }

    static boolean processGeometries(BytesRef lhs, BytesRef rhs) {
        return false == lhs.equals((Object)rhs);
    }

    public EsqlBinaryComparison reverse() {
        return this;
    }

    protected NodeInfo<NotEquals> info() {
        return NodeInfo.create((Node)this, NotEquals::new, (Object)this.left(), (Object)this.right(), (Object)this.zoneId());
    }

    protected NotEquals replaceChildren(Expression newLeft, Expression newRight) {
        return new NotEquals(this.source(), newLeft, newRight, this.zoneId());
    }

    public NotEquals swapLeftAndRight() {
        return new NotEquals(this.source(), this.right(), this.left(), this.zoneId());
    }

    public EsqlBinaryComparison negate() {
        return new Equals(this.source(), this.left(), this.right(), this.zoneId());
    }
}

