/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.esql.expression.function.scalar.math;

import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.compute.data.Block;
import org.elasticsearch.compute.data.DoubleBlock;
import org.elasticsearch.compute.data.DoubleVector;
import org.elasticsearch.compute.data.LongBlock;
import org.elasticsearch.compute.data.LongVector;
import org.elasticsearch.compute.data.Page;
import org.elasticsearch.compute.operator.DriverContext;
import org.elasticsearch.compute.operator.EvalOperator;
import org.elasticsearch.compute.operator.Warnings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.xpack.esql.core.tree.Source;
import org.elasticsearch.xpack.esql.expression.function.scalar.math.Cast;

public final class CastUnsignedLongToDoubleEvaluator
implements EvalOperator.ExpressionEvaluator {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CastUnsignedLongToDoubleEvaluator.class);
    private final Source source;
    private final EvalOperator.ExpressionEvaluator v;
    private final DriverContext driverContext;
    private Warnings warnings;

    public CastUnsignedLongToDoubleEvaluator(Source source, EvalOperator.ExpressionEvaluator v, DriverContext driverContext) {
        this.source = source;
        this.v = v;
        this.driverContext = driverContext;
    }

    public Block eval(Page page) {
        try (LongBlock vBlock = (LongBlock)this.v.eval(page);){
            LongVector vVector = vBlock.asVector();
            if (vVector == null) {
                DoubleBlock doubleBlock = this.eval(page.getPositionCount(), vBlock);
                return doubleBlock;
            }
            DoubleBlock doubleBlock = this.eval(page.getPositionCount(), vVector).asBlock();
            return doubleBlock;
        }
    }

    public long baseRamBytesUsed() {
        long baseRamBytesUsed = BASE_RAM_BYTES_USED;
        return baseRamBytesUsed += this.v.baseRamBytesUsed();
    }

    public DoubleBlock eval(int positionCount, LongBlock vBlock) {
        try (DoubleBlock.Builder result = this.driverContext.blockFactory().newDoubleBlockBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                if (vBlock.isNull(p)) {
                    result.appendNull();
                    continue;
                }
                if (vBlock.getValueCount(p) != 1) {
                    if (vBlock.getValueCount(p) > 1) {
                        this.warnings().registerException((Exception)new IllegalArgumentException("single-value function encountered multi-value"));
                    }
                    result.appendNull();
                    continue;
                }
                result.appendDouble(Cast.castUnsignedLongToDouble(vBlock.getLong(vBlock.getFirstValueIndex(p))));
            }
            DoubleBlock doubleBlock = result.build();
            return doubleBlock;
        }
    }

    public DoubleVector eval(int positionCount, LongVector vVector) {
        try (DoubleVector.FixedBuilder result = this.driverContext.blockFactory().newDoubleVectorFixedBuilder(positionCount);){
            for (int p = 0; p < positionCount; ++p) {
                result.appendDouble(p, Cast.castUnsignedLongToDouble(vVector.getLong(p)));
            }
            DoubleVector doubleVector = result.build();
            return doubleVector;
        }
    }

    public String toString() {
        return "CastUnsignedLongToDoubleEvaluator[v=" + String.valueOf(this.v) + "]";
    }

    public void close() {
        Releasables.closeExpectNoException((Releasable)this.v);
    }

    private Warnings warnings() {
        if (this.warnings == null) {
            this.warnings = Warnings.createWarnings((DriverContext.WarningsMode)this.driverContext.warningsMode(), (int)this.source.source().getLineNumber(), (int)this.source.source().getColumnNumber(), (String)this.source.text());
        }
        return this.warnings;
    }

    static class Factory
    implements EvalOperator.ExpressionEvaluator.Factory {
        private final Source source;
        private final EvalOperator.ExpressionEvaluator.Factory v;

        public Factory(Source source, EvalOperator.ExpressionEvaluator.Factory v) {
            this.source = source;
            this.v = v;
        }

        public CastUnsignedLongToDoubleEvaluator get(DriverContext context) {
            return new CastUnsignedLongToDoubleEvaluator(this.source, this.v.get(context), context);
        }

        public String toString() {
            return "CastUnsignedLongToDoubleEvaluator[v=" + String.valueOf(this.v) + "]";
        }
    }
}

