/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.transport.TransportActionStatsTracker;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public record TransportActionStats(long requestCount, long totalRequestSize, long[] requestSizeHistogram, long responseCount, long totalResponseSize, long[] responseSizeHistogram) implements Writeable,
ToXContentObject
{
    public static final TransportActionStats EMPTY = new TransportActionStats(0L, 0L, new long[0], 0L, 0L, new long[0]);

    public TransportActionStats(StreamInput in) throws IOException {
        this(in.readVLong(), in.readVLong(), in.readVLongArray(), in.readVLong(), in.readVLong(), in.readVLongArray());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.startObject("requests");
        builder.field("count", this.requestCount);
        builder.humanReadableField("total_size_in_bytes", "total_size", (Object)ByteSizeValue.ofBytes(this.totalRequestSize));
        TransportActionStats.histogramToXContent(builder, this.requestSizeHistogram);
        builder.endObject();
        builder.startObject("responses");
        builder.field("count", this.responseCount);
        builder.humanReadableField("total_size_in_bytes", "total_size", (Object)ByteSizeValue.ofBytes(this.totalResponseSize));
        TransportActionStats.histogramToXContent(builder, this.responseSizeHistogram);
        builder.endObject();
        return builder.endObject();
    }

    static void histogramToXContent(XContentBuilder builder, long[] sizeHistogram) throws IOException {
        int i;
        int[] bucketBounds = TransportActionStatsTracker.getBucketUpperBounds();
        assert (sizeHistogram.length == bucketBounds.length + 1);
        builder.startArray("histogram");
        int firstBucket = 0;
        long remainingCount = 0L;
        for (i = 0; i < sizeHistogram.length; ++i) {
            if (remainingCount == 0L) {
                firstBucket = i;
            }
            remainingCount += sizeHistogram[i];
        }
        for (i = firstBucket; i < sizeHistogram.length && 0L < remainingCount; remainingCount -= sizeHistogram[i], ++i) {
            builder.startObject();
            if (i > 0) {
                builder.humanReadableField("ge_bytes", "ge", (Object)ByteSizeValue.ofBytes(bucketBounds[i - 1]));
            }
            if (i < bucketBounds.length) {
                builder.humanReadableField("lt_bytes", "lt", (Object)ByteSizeValue.ofBytes(bucketBounds[i]));
            }
            builder.field("count", sizeHistogram[i]);
            builder.endObject();
        }
        builder.endArray();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.requestCount);
        out.writeVLong(this.totalRequestSize);
        out.writeVLongArray(this.requestSizeHistogram);
        out.writeVLong(this.responseCount);
        out.writeVLong(this.totalResponseSize);
        out.writeVLongArray(this.responseSizeHistogram);
    }
}

