/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest;

import java.util.Map;
import java.util.function.BiConsumer;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.ingest.AbstractProcessor;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.IngestDocument;
import org.elasticsearch.ingest.IngestService;
import org.elasticsearch.ingest.Pipeline;
import org.elasticsearch.ingest.Processor;
import org.elasticsearch.script.TemplateScript;

public class PipelineProcessor
extends AbstractProcessor {
    public static final String TYPE = "pipeline";
    private final TemplateScript.Factory pipelineTemplate;
    private final boolean ignoreMissingPipeline;
    private final IngestService ingestService;

    PipelineProcessor(String tag, String description, TemplateScript.Factory pipelineTemplate, boolean ignoreMissingPipeline, IngestService ingestService) {
        super(tag, description);
        this.pipelineTemplate = pipelineTemplate;
        this.ignoreMissingPipeline = ignoreMissingPipeline;
        this.ingestService = ingestService;
    }

    public boolean isIgnoreMissingPipeline() {
        return this.ignoreMissingPipeline;
    }

    @Override
    public void execute(IngestDocument ingestDocument, BiConsumer<IngestDocument, Exception> handler) {
        String pipelineName = ingestDocument.renderTemplate(this.pipelineTemplate);
        Pipeline pipeline = this.ingestService.getPipeline(pipelineName);
        if (pipeline != null) {
            ingestDocument.executePipeline(pipeline, handler);
        } else if (this.ignoreMissingPipeline) {
            handler.accept(ingestDocument, null);
        } else {
            handler.accept(null, new IllegalStateException("Pipeline processor configured for non-existent pipeline [" + pipelineName + "]"));
        }
    }

    Pipeline getPipeline(IngestDocument ingestDocument) {
        return this.ingestService.getPipeline(this.getPipelineToCallName(ingestDocument));
    }

    String getPipelineToCallName(IngestDocument ingestDocument) {
        return ingestDocument.renderTemplate(this.pipelineTemplate);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public boolean isAsync() {
        return true;
    }

    TemplateScript.Factory getPipelineTemplate() {
        return this.pipelineTemplate;
    }

    public static final class Factory
    implements Processor.Factory {
        private final IngestService ingestService;

        public Factory(IngestService ingestService) {
            this.ingestService = ingestService;
        }

        @Override
        public PipelineProcessor create(Map<String, Processor.Factory> registry, String processorTag, String description, Map<String, Object> config, ProjectId projectId) throws Exception {
            TemplateScript.Factory pipelineTemplate = ConfigurationUtils.readTemplateProperty(PipelineProcessor.TYPE, processorTag, config, "name", this.ingestService.getScriptService());
            boolean ignoreMissingPipeline = ConfigurationUtils.readBooleanProperty(PipelineProcessor.TYPE, processorTag, config, "ignore_missing_pipeline", false);
            return new PipelineProcessor(processorTag, description, pipelineTemplate, ignoreMissingPipeline, this.ingestService);
        }
    }
}

