/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.DocBaseBitSetIterator;
import org.apache.lucene.util.FixedBitSet;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.hnsw.IntToIntFunction;

final class DocIdsWriter {
    public static final int DEFAULT_MAX_POINTS_IN_LEAF_NODE = 512;
    private static final byte CONTINUOUS_IDS = -2;
    private static final byte BITSET_IDS = -1;
    private static final byte DELTA_BPV_16 = 16;
    private static final byte BPV_21 = 21;
    private static final byte BPV_24 = 24;
    private static final byte BPV_32 = 32;
    private int[] scratch = new int[0];
    private final LongsRef scratchLongs = new LongsRef();
    private final IntsRef scratchIntsRef = new IntsRef();

    DocIdsWriter() {
        this.scratchIntsRef.offset = 0;
    }

    void writeDocIds(IntToIntFunction docIds, int count, DataOutput out) throws IOException {
        block26: {
            int i;
            int max;
            block25: {
                int i2;
                int min;
                if (count == 0) {
                    return;
                }
                if (count > this.scratch.length) {
                    this.scratch = new int[count];
                }
                boolean strictlySorted = true;
                max = min = docIds.apply(0);
                for (int i3 = 1; i3 < count; ++i3) {
                    int current;
                    int last = docIds.apply(i3 - 1);
                    if (last >= (current = docIds.apply(i3))) {
                        strictlySorted = false;
                    }
                    min = Math.min(min, current);
                    max = Math.max(max, current);
                }
                int min2max = max - min + 1;
                if (strictlySorted) {
                    if (min2max == count) {
                        out.writeByte((byte)-2);
                        out.writeVInt(docIds.apply(0));
                        return;
                    }
                    if (min2max <= count << 4) {
                        assert (min2max > count) : "min2max: " + min2max + ", count: " + count;
                        out.writeByte((byte)-1);
                        DocIdsWriter.writeIdsAsBitSet(docIds, count, out);
                        return;
                    }
                }
                if (min2max > 65535) break block25;
                out.writeByte((byte)16);
                for (i = 0; i < count; ++i) {
                    this.scratch[i] = docIds.apply(i) - min;
                }
                out.writeVInt(min);
                int halfLen = count >> 1;
                for (i2 = 0; i2 < halfLen; ++i2) {
                    this.scratch[i2] = this.scratch[halfLen + i2] | this.scratch[i2] << 16;
                }
                for (i2 = 0; i2 < halfLen; ++i2) {
                    out.writeInt(this.scratch[i2]);
                }
                if ((count & 1) != 1) break block26;
                out.writeShort((short)this.scratch[count - 1]);
                break block26;
            }
            if (max <= 0x1FFFFF) {
                int i4;
                out.writeByte((byte)21);
                int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
                numInts = oneThird * 2;
                for (i4 = 0; i4 < numInts; ++i4) {
                    this.scratch[i4] = docIds.apply(i4) << 11;
                }
                for (i4 = 0; i4 < oneThird; ++i4) {
                    int longIdx = i4 + numInts;
                    int n = i4;
                    this.scratch[n] = this.scratch[n] | docIds.apply(longIdx) & 0x7FF;
                    int n2 = i4 + oneThird;
                    this.scratch[n2] = this.scratch[n2] | docIds.apply(longIdx) >>> 11 & 0x7FF;
                }
                for (i4 = 0; i4 < numInts; ++i4) {
                    out.writeInt(this.scratch[i4]);
                }
                for (i4 = oneThird * 3; i4 < count - 2; i4 += 3) {
                    out.writeLong((long)docIds.apply(i4) | (long)docIds.apply(i4 + 1) << 21 | (long)docIds.apply(i4 + 2) << 42);
                }
                while (i4 < count) {
                    out.writeShort((short)docIds.apply(i4));
                    out.writeByte((byte)(docIds.apply(i4) >>> 16));
                    ++i4;
                }
            } else if (max <= 0xFFFFFF) {
                int i5;
                out.writeByte((byte)24);
                int quarter = count >> 2;
                numInts = quarter * 3;
                for (i5 = 0; i5 < numInts; ++i5) {
                    this.scratch[i5] = docIds.apply(i5) << 8;
                }
                for (i5 = 0; i5 < quarter; ++i5) {
                    int longIdx = i5 + numInts;
                    int n = i5;
                    this.scratch[n] = this.scratch[n] | docIds.apply(longIdx) & 0xFF;
                    int n3 = i5 + quarter;
                    this.scratch[n3] = this.scratch[n3] | docIds.apply(longIdx) >>> 8 & 0xFF;
                    int n4 = i5 + quarter * 2;
                    this.scratch[n4] = this.scratch[n4] | docIds.apply(longIdx) >>> 16;
                }
                for (i5 = 0; i5 < numInts; ++i5) {
                    out.writeInt(this.scratch[i5]);
                }
                for (i5 = quarter << 2; i5 < count; ++i5) {
                    out.writeShort((short)docIds.apply(i5));
                    out.writeByte((byte)(docIds.apply(i5) >>> 16));
                }
            } else {
                out.writeByte((byte)32);
                for (i = 0; i < count; ++i) {
                    out.writeInt(docIds.apply(i));
                }
            }
        }
    }

    private static void writeIdsAsBitSet(IntToIntFunction docIds, int count, DataOutput out) throws IOException {
        int min = docIds.apply(0);
        int max = docIds.apply(count - 1);
        int offsetWords = min >> 6;
        int offsetBits = offsetWords << 6;
        int totalWordCount = FixedBitSet.bits2words((int)(max - offsetBits + 1));
        long currentWord = 0L;
        int currentWordIndex = 0;
        out.writeVInt(offsetWords);
        out.writeVInt(totalWordCount);
        for (int i = 0; i < count; ++i) {
            int index = docIds.apply(i) - offsetBits;
            int nextWordIndex = index >> 6;
            assert (currentWordIndex <= nextWordIndex);
            if (currentWordIndex < nextWordIndex) {
                out.writeLong(currentWord);
                currentWord = 0L;
                ++currentWordIndex;
                while (currentWordIndex < nextWordIndex) {
                    ++currentWordIndex;
                    out.writeLong(0L);
                }
            }
            currentWord |= 1L << index;
        }
        out.writeLong(currentWord);
        assert (currentWordIndex + 1 == totalWordCount);
    }

    void readInts(IndexInput in, int count, int[] docIDs) throws IOException {
        if (count == 0) {
            return;
        }
        if (count > this.scratch.length) {
            this.scratch = new int[count];
        }
        byte bpv = in.readByte();
        switch (bpv) {
            case -2: {
                DocIdsWriter.readContinuousIds(in, count, docIDs);
                break;
            }
            case -1: {
                this.readBitSet(in, count, docIDs);
                break;
            }
            case 16: {
                DocIdsWriter.readDelta16(in, count, docIDs);
                break;
            }
            case 21: {
                this.readInts21(in, count, docIDs);
                break;
            }
            case 24: {
                this.readInts24(in, count, docIDs);
                break;
            }
            case 32: {
                DocIdsWriter.readInts32(in, count, docIDs);
                break;
            }
            default: {
                throw new IOException("Unsupported number of bits per value: " + bpv);
            }
        }
    }

    private DocIdSetIterator readBitSetIterator(IndexInput in, int count) throws IOException {
        int offsetWords = in.readVInt();
        int longLen = in.readVInt();
        this.scratchLongs.longs = ArrayUtil.growNoCopy((long[])this.scratchLongs.longs, (int)longLen);
        in.readLongs(this.scratchLongs.longs, 0, longLen);
        if (longLen < this.scratchLongs.length) {
            Arrays.fill(this.scratchLongs.longs, longLen, this.scratchLongs.longs.length, 0L);
        }
        this.scratchLongs.length = longLen;
        FixedBitSet bitSet = new FixedBitSet(this.scratchLongs.longs, longLen << 6);
        return new DocBaseBitSetIterator(bitSet, (long)count, offsetWords << 6);
    }

    private static void readContinuousIds(IndexInput in, int count, int[] docIDs) throws IOException {
        int start = in.readVInt();
        for (int i = 0; i < count; ++i) {
            docIDs[i] = start + i;
        }
    }

    private void readBitSet(IndexInput in, int count, int[] docIDs) throws IOException {
        int docId;
        DocIdSetIterator iterator = this.readBitSetIterator(in, count);
        int pos = 0;
        while ((docId = iterator.nextDoc()) != Integer.MAX_VALUE) {
            docIDs[pos++] = docId;
        }
        assert (pos == count) : "pos: " + pos + ", count: " + count;
    }

    private static void readDelta16(IndexInput in, int count, int[] docIds) throws IOException {
        int min = in.readVInt();
        int half = count >> 1;
        in.readInts(docIds, 0, half);
        if (count == 512) {
            DocIdsWriter.decode16(docIds, 256, min);
        } else {
            DocIdsWriter.decode16(docIds, half, min);
        }
        for (int i = half << 1; i < count; ++i) {
            docIds[i] = Short.toUnsignedInt(in.readShort()) + min;
        }
    }

    private static void decode16(int[] docIDs, int half, int min) {
        for (int i = 0; i < half; ++i) {
            int l = docIDs[i];
            docIDs[i] = (l >>> 16) + min;
            docIDs[i + half] = (l & 0xFFFF) + min;
        }
    }

    private static int floorToMultipleOf16(int n) {
        assert (n >= 0);
        return n & 0xFFFFFFF0;
    }

    private void readInts21(IndexInput in, int count, int[] docIDs) throws IOException {
        int i;
        int oneThird = DocIdsWriter.floorToMultipleOf16(count / 3);
        int numInts = oneThird << 1;
        in.readInts(this.scratch, 0, numInts);
        if (count == 512) {
            DocIdsWriter.decode21(docIDs, this.scratch, DocIdsWriter.floorToMultipleOf16(170), DocIdsWriter.floorToMultipleOf16(170) * 2);
        } else {
            DocIdsWriter.decode21(docIDs, this.scratch, oneThird, numInts);
        }
        for (i = oneThird * 3; i < count - 2; i += 3) {
            long l = in.readLong();
            docIDs[i] = (int)(l & 0x1FFFFFL);
            docIDs[i + 1] = (int)(l >>> 21 & 0x1FFFFFL);
            docIDs[i + 2] = (int)(l >>> 42);
        }
        while (i < count) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
            ++i;
        }
    }

    private static void decode21(int[] docIds, int[] scratch, int oneThird, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIds[i] = scratch[i] >>> 11;
        }
        for (i = 0; i < oneThird; ++i) {
            docIds[i + numInts] = scratch[i] & 0x7FF | (scratch[i + oneThird] & 0x7FF) << 11;
        }
    }

    private void readInts24(IndexInput in, int count, int[] docIDs) throws IOException {
        int quarter = count >> 2;
        int numInts = quarter * 3;
        in.readInts(this.scratch, 0, numInts);
        if (count == 512) {
            assert (DocIdsWriter.floorToMultipleOf16(quarter) == quarter) : "We are relying on the fact that quarter of DEFAULT_MAX_POINTS_IN_LEAF_NODE is a multiple of 16 to vectorize the decoding loop, please check performance issue if you want to break this assumption.";
            DocIdsWriter.decode24(docIDs, this.scratch, 128, 384);
        } else {
            DocIdsWriter.decode24(docIDs, this.scratch, quarter, numInts);
        }
        for (int i = quarter << 2; i < count; ++i) {
            docIDs[i] = in.readShort() & 0xFFFF | (in.readByte() & 0xFF) << 16;
        }
    }

    private static void decode24(int[] docIDs, int[] scratch, int quarter, int numInts) {
        int i;
        for (i = 0; i < numInts; ++i) {
            docIDs[i] = scratch[i] >>> 8;
        }
        for (i = 0; i < quarter; ++i) {
            docIDs[i + numInts] = scratch[i] & 0xFF | (scratch[i + quarter] & 0xFF) << 8 | (scratch[i + quarter * 2] & 0xFF) << 16;
        }
    }

    private static void readInts32(IndexInput in, int count, int[] docIDs) throws IOException {
        in.readInts(docIDs, 0, count);
    }
}

