/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster;

import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ProjectState;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public class ProjectStateObserver {
    private final ProjectId projectId;
    private final ClusterStateObserver clusterObserver;

    public ProjectStateObserver(ProjectState initialState, ClusterService clusterService, @Nullable TimeValue timeout, Logger logger, ThreadContext contextHolder) {
        this(initialState.projectId(), initialState.cluster(), clusterService, timeout, logger, contextHolder);
    }

    private ProjectStateObserver(ProjectId projectId, ClusterState initialClusterState, ClusterService clusterService, @Nullable TimeValue timeout, Logger logger, ThreadContext contextHolder) {
        this.projectId = projectId;
        this.clusterObserver = new ClusterStateObserver(initialClusterState, clusterService, timeout, logger, contextHolder);
    }

    public void waitForNextChange(Listener listener, @Nullable TimeValue timeOutValue) {
        this.clusterObserver.waitForNextChange((ClusterStateObserver.Listener)new ListenerAdapter(listener), timeOutValue);
    }

    public boolean isTimedOut() {
        return this.clusterObserver.isTimedOut();
    }

    public void observeLastAppliedState(Listener listener) {
        this.applyProjectState(this.clusterObserver.setAndGetObservedState(), listener);
    }

    private void applyProjectState(ClusterState clusterState, Listener listener) {
        if (clusterState.metadata().hasProject(this.projectId)) {
            listener.onProjectStateChange(clusterState.projectState(this.projectId));
        } else {
            listener.onProjectMissing(this.projectId, clusterState);
        }
    }

    private class ListenerAdapter
    implements ClusterStateObserver.Listener {
        private final Listener delegate;

        private ListenerAdapter(Listener delegate) {
            this.delegate = delegate;
        }

        @Override
        public final void onNewClusterState(ClusterState clusterState) {
            ProjectStateObserver.this.applyProjectState(clusterState, this.delegate);
        }

        @Override
        public void onClusterServiceClose() {
            this.delegate.onClusterServiceClose();
        }

        @Override
        public void onTimeout(TimeValue timeout) {
            this.delegate.onTimeout(timeout);
        }
    }

    public static interface Listener {
        public void onProjectStateChange(ProjectState var1);

        public void onProjectMissing(ProjectId var1, ClusterState var2);

        public void onClusterServiceClose();

        public void onTimeout(TimeValue var1);
    }
}

