/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.http.netty4.Netty4ChunkedHttpResponse;
import org.elasticsearch.http.netty4.Netty4FullHttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class Netty4HttpRequest
implements HttpRequest {
    private final int sequence;
    private final io.netty.handler.codec.http.HttpRequest nettyRequest;
    private boolean hasContent;
    private HttpBody content;
    private final Map<String, List<String>> headers;
    private final AtomicBoolean released;
    private final Exception inboundException;
    private final QueryStringDecoder queryStringDecoder;

    public Netty4HttpRequest(int sequence, io.netty.handler.codec.http.HttpRequest nettyRequest, Exception exception) {
        this(sequence, nettyRequest, (HttpBody)HttpBody.empty(), new AtomicBoolean(false), exception);
    }

    public Netty4HttpRequest(int sequence, io.netty.handler.codec.http.HttpRequest nettyRequest, HttpBody content) {
        this(sequence, nettyRequest, content, new AtomicBoolean(false), null);
    }

    private Netty4HttpRequest(int sequence, io.netty.handler.codec.http.HttpRequest nettyRequest, HttpBody content, AtomicBoolean released, Exception inboundException) {
        this.sequence = sequence;
        this.nettyRequest = nettyRequest;
        this.hasContent = Netty4HttpRequest.hasContentHeader(nettyRequest);
        this.content = content;
        this.headers = Netty4HttpRequest.getHttpHeadersAsMap(nettyRequest.headers());
        this.released = released;
        this.inboundException = inboundException;
        this.queryStringDecoder = new QueryStringDecoder(nettyRequest.uri());
    }

    private static boolean hasContentHeader(io.netty.handler.codec.http.HttpRequest nettyRequest) {
        return HttpUtil.isTransferEncodingChunked((HttpMessage)nettyRequest) || HttpUtil.getContentLength((HttpMessage)nettyRequest, (long)0L) > 0L;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public RestRequest.Method method() {
        return Netty4HttpRequest.translateRequestMethod(this.nettyRequest.method());
    }

    public String uri() {
        return this.nettyRequest.uri();
    }

    public String rawPath() {
        return this.queryStringDecoder.rawPath();
    }

    public HttpBody body() {
        assert (!this.released.get());
        return this.content;
    }

    public void setBody(HttpBody body) {
        assert (this.content.isStream()) : "only stream content can be replaced";
        assert (body.isFull()) : "only full content can replace stream";
        this.content = body;
        this.hasContent = !body.isEmpty();
    }

    public void release() {
        if (this.released.compareAndSet(false, true)) {
            this.content.close();
        }
    }

    public final Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public List<String> strictCookies() {
        Set cookies;
        String cookieString = this.nettyRequest.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        if (cookieString != null && !(cookies = ServerCookieDecoder.STRICT.decode(cookieString)).isEmpty()) {
            return ServerCookieEncoder.STRICT.encode((Collection)cookies);
        }
        return Collections.emptyList();
    }

    public HttpRequest.HttpVersion protocolVersion() {
        if (this.nettyRequest.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            return HttpRequest.HttpVersion.HTTP_1_0;
        }
        if (this.nettyRequest.protocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            return HttpRequest.HttpVersion.HTTP_1_1;
        }
        throw new IllegalArgumentException("Unexpected http protocol version: " + String.valueOf(this.nettyRequest.protocolVersion()));
    }

    public HttpRequest removeHeader(String header) {
        HttpHeaders copiedHeadersWithout = this.nettyRequest.headers().copy();
        copiedHeadersWithout.remove(header);
        DefaultHttpRequest requestWithoutHeader = new DefaultHttpRequest(this.nettyRequest.protocolVersion(), this.nettyRequest.method(), this.nettyRequest.uri(), copiedHeadersWithout);
        return new Netty4HttpRequest(this.sequence, (io.netty.handler.codec.http.HttpRequest)requestWithoutHeader, this.content, this.released, null);
    }

    public Netty4FullHttpResponse createResponse(RestStatus status, BytesReference contentRef) {
        return new Netty4FullHttpResponse(this.sequence, this.nettyRequest.protocolVersion(), status, contentRef);
    }

    public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart firstBodyPart) {
        return new Netty4ChunkedHttpResponse(this.sequence, this.nettyRequest.protocolVersion(), status, firstBodyPart);
    }

    public Exception getInboundException() {
        return this.inboundException;
    }

    public io.netty.handler.codec.http.HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public static RestRequest.Method translateRequestMethod(HttpMethod httpMethod) {
        if (httpMethod == HttpMethod.GET) {
            return RestRequest.Method.GET;
        }
        if (httpMethod == HttpMethod.POST) {
            return RestRequest.Method.POST;
        }
        if (httpMethod == HttpMethod.PUT) {
            return RestRequest.Method.PUT;
        }
        if (httpMethod == HttpMethod.DELETE) {
            return RestRequest.Method.DELETE;
        }
        if (httpMethod == HttpMethod.HEAD) {
            return RestRequest.Method.HEAD;
        }
        if (httpMethod == HttpMethod.OPTIONS) {
            return RestRequest.Method.OPTIONS;
        }
        if (httpMethod == HttpMethod.PATCH) {
            return RestRequest.Method.PATCH;
        }
        if (httpMethod == HttpMethod.TRACE) {
            return RestRequest.Method.TRACE;
        }
        if (httpMethod == HttpMethod.CONNECT) {
            return RestRequest.Method.CONNECT;
        }
        throw new IllegalArgumentException("Unexpected http method: " + String.valueOf(httpMethod));
    }

    public static Map<String, List<String>> getHttpHeadersAsMap(HttpHeaders httpHeaders) {
        return new HttpHeadersMap(httpHeaders);
    }

    private static class HttpHeadersMap
    implements Map<String, List<String>> {
        private final HttpHeaders httpHeaders;

        private HttpHeadersMap(HttpHeaders httpHeaders) {
            this.httpHeaders = httpHeaders;
        }

        @Override
        public int size() {
            return this.httpHeaders.size();
        }

        @Override
        public boolean isEmpty() {
            return this.httpHeaders.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return key instanceof String && this.httpHeaders.contains((String)key);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean containsValue(Object value) {
            if (!(value instanceof List)) return false;
            if (!this.httpHeaders.names().stream().map(arg_0 -> ((HttpHeaders)this.httpHeaders).getAll(arg_0)).anyMatch(value::equals)) return false;
            return true;
        }

        @Override
        public List<String> get(Object key) {
            return key instanceof String ? this.httpHeaders.getAll((String)key) : null;
        }

        @Override
        public List<String> put(String key, List<String> value) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public List<String> remove(Object key) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void putAll(Map<? extends String, ? extends List<String>> m) {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("modifications are not supported");
        }

        @Override
        public Set<String> keySet() {
            return this.httpHeaders.names();
        }

        @Override
        public Collection<List<String>> values() {
            return this.httpHeaders.names().stream().map(k -> Collections.unmodifiableList(this.httpHeaders.getAll(k))).toList();
        }

        @Override
        public Set<Map.Entry<String, List<String>>> entrySet() {
            return this.httpHeaders.names().stream().map(k -> new AbstractMap.SimpleImmutableEntry<String, List>((String)k, this.httpHeaders.getAll(k))).collect(Collectors.toSet());
        }
    }
}

