/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.state.ClusterStateRequest;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.AcknowledgedTransportMasterNodeAction;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.client.internal.RemoteClusterClient;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.ccr.CcrLicenseChecker;
import org.elasticsearch.xpack.ccr.action.TransportResumeFollowAction;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ccr.AutoFollowMetadata;
import org.elasticsearch.xpack.core.ccr.action.PutAutoFollowPatternAction;

public class TransportPutAutoFollowPatternAction
extends AcknowledgedTransportMasterNodeAction<PutAutoFollowPatternAction.Request> {
    private final Client client;
    private final CcrLicenseChecker ccrLicenseChecker;
    private final Executor remoteClientResponseExecutor;

    @Inject
    public TransportPutAutoFollowPatternAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, Client client, CcrLicenseChecker ccrLicenseChecker) {
        super("cluster:admin/xpack/ccr/auto_follow_pattern/put", transportService, clusterService, threadPool, actionFilters, PutAutoFollowPatternAction.Request::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.client = client;
        this.remoteClientResponseExecutor = threadPool.executor("ccr");
        this.ccrLicenseChecker = Objects.requireNonNull(ccrLicenseChecker, "ccrLicenseChecker");
    }

    protected void masterOperation(Task task, final PutAutoFollowPatternAction.Request request, ClusterState state, ActionListener<AcknowledgedResponse> listener) {
        if (!this.ccrLicenseChecker.isCcrAllowed()) {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ccr"));
            return;
        }
        Settings replicatedRequestSettings = TransportResumeFollowAction.filter(request.getSettings());
        if (!replicatedRequestSettings.isEmpty()) {
            String message = String.format(Locale.ROOT, "can not put auto-follow pattern that could override leader settings %s", replicatedRequestSettings);
            listener.onFailure((Exception)new IllegalArgumentException(message));
            return;
        }
        RemoteClusterClient remoteClient = this.client.getRemoteClusterClient(request.getRemoteCluster(), this.remoteClientResponseExecutor, RemoteClusterService.DisconnectedStrategy.RECONNECT_IF_DISCONNECTED);
        final Map filteredHeaders = ClientHelper.getPersistableSafeSecurityHeaders((ThreadContext)this.threadPool.getThreadContext(), (ClusterState)this.clusterService.state());
        Consumer<ClusterStateResponse> consumer = remoteClusterState -> {
            String[] indices = request.getLeaderIndexPatterns().toArray(new String[0]);
            this.ccrLicenseChecker.hasPrivilegesToFollowIndices(this.client.threadPool().getThreadContext(), remoteClient, indices, e -> {
                if (e == null) {
                    this.submitUnbatchedTask("put-auto-follow-pattern-" + request.getRemoteCluster(), (ClusterStateUpdateTask)new AckedClusterStateUpdateTask(this, (AcknowledgedRequest)request, (ActionListener)listener, (ClusterStateResponse)remoteClusterState){
                        final /* synthetic */ ClusterStateResponse val$remoteClusterState;
                        {
                            this.val$remoteClusterState = clusterStateResponse;
                            super(arg0, arg1);
                        }

                        public ClusterState execute(ClusterState currentState) {
                            return TransportPutAutoFollowPatternAction.innerPut(request, filteredHeaders, currentState, this.val$remoteClusterState.getState());
                        }
                    });
                } else {
                    listener.onFailure(e);
                }
            });
        };
        CcrLicenseChecker.checkRemoteClusterLicenseAndFetchClusterState(this.client, request.getRemoteCluster(), new ClusterStateRequest(request.masterNodeTimeout()).clear().metadata(true), arg_0 -> listener.onFailure(arg_0), consumer);
    }

    @SuppressForbidden(reason="legacy usage of unbatched task")
    private void submitUnbatchedTask(String source, ClusterStateUpdateTask task) {
        this.clusterService.submitUnbatchedStateUpdateTask(source, task);
    }

    static ClusterState innerPut(PutAutoFollowPatternAction.Request request, Map<String, String> filteredHeaders, ClusterState localState, ClusterState remoteClusterState) {
        HashMap<String, Map<String, String>> headers;
        HashMap<String, ArrayList<String>> followedLeaderIndices;
        HashMap<String, AutoFollowMetadata.AutoFollowPattern> patterns;
        ProjectMetadata localProject = localState.metadata().getProject();
        AutoFollowMetadata currentAutoFollowMetadata = (AutoFollowMetadata)localProject.custom("ccr_auto_follow");
        if (currentAutoFollowMetadata != null) {
            patterns = new HashMap(currentAutoFollowMetadata.getPatterns());
            followedLeaderIndices = new HashMap(currentAutoFollowMetadata.getFollowedLeaderIndexUUIDs());
            headers = new HashMap(currentAutoFollowMetadata.getHeaders());
        } else {
            patterns = new HashMap<String, AutoFollowMetadata.AutoFollowPattern>();
            followedLeaderIndices = new HashMap<String, ArrayList<String>>();
            headers = new HashMap<String, Map<String, String>>();
        }
        AutoFollowMetadata.AutoFollowPattern previousPattern = (AutoFollowMetadata.AutoFollowPattern)patterns.get(request.getName());
        ArrayList<String> followedIndexUUIDs = followedLeaderIndices.containsKey(request.getName()) ? new ArrayList((Collection)followedLeaderIndices.get(request.getName())) : new ArrayList<String>();
        followedLeaderIndices.put(request.getName(), followedIndexUUIDs);
        if (previousPattern != null) {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowedForNewPatterns(request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), remoteClusterState.metadata(), previousPattern, followedIndexUUIDs);
        } else {
            TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), remoteClusterState.metadata(), followedIndexUUIDs);
        }
        if (filteredHeaders != null) {
            headers.put(request.getName(), filteredHeaders);
        }
        AutoFollowMetadata.AutoFollowPattern autoFollowPattern = new AutoFollowMetadata.AutoFollowPattern(request.getRemoteCluster(), request.getLeaderIndexPatterns(), request.getLeaderIndexExclusionPatterns(), request.getFollowIndexNamePattern(), request.getSettings(), true, request.getParameters().getMaxReadRequestOperationCount(), request.getParameters().getMaxWriteRequestOperationCount(), request.getParameters().getMaxOutstandingReadRequests(), request.getParameters().getMaxOutstandingWriteRequests(), request.getParameters().getMaxReadRequestSize(), request.getParameters().getMaxWriteRequestSize(), request.getParameters().getMaxWriteBufferCount(), request.getParameters().getMaxWriteBufferSize(), request.getParameters().getMaxRetryDelay(), request.getParameters().getReadPollTimeout());
        patterns.put(request.getName(), autoFollowPattern);
        return localState.copyAndUpdateProject(localProject.id(), builder -> builder.putCustom("ccr_auto_follow", (Metadata.ProjectCustom)new AutoFollowMetadata(patterns, followedLeaderIndices, headers)));
    }

    private static void markExistingIndicesAsAutoFollowedForNewPatterns(List<String> leaderIndexPatterns, List<String> leaderIndexExclusionPatterns, Metadata leaderMetadata, AutoFollowMetadata.AutoFollowPattern previousPattern, List<String> followedIndexUUIDS) {
        List<String> newPatterns = leaderIndexPatterns.stream().filter(p -> !previousPattern.getLeaderIndexPatterns().contains(p)).collect(Collectors.toList());
        TransportPutAutoFollowPatternAction.markExistingIndicesAsAutoFollowed(newPatterns, leaderIndexExclusionPatterns, leaderMetadata, followedIndexUUIDS);
    }

    private static void markExistingIndicesAsAutoFollowed(List<String> patterns, List<String> exclusionPatterns, Metadata leaderMetadata, List<String> followedIndexUUIDS) {
        for (IndexMetadata indexMetadata : leaderMetadata.getProject()) {
            IndexAbstraction indexAbstraction = (IndexAbstraction)leaderMetadata.getProject().getIndicesLookup().get(indexMetadata.getIndex().getName());
            if (!AutoFollowMetadata.AutoFollowPattern.match(patterns, exclusionPatterns, (IndexAbstraction)indexAbstraction)) continue;
            followedIndexUUIDS.add(indexMetadata.getIndexUUID());
        }
    }

    protected ClusterBlockException checkBlock(PutAutoFollowPatternAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

