/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.search;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;

public class SearchTemplateHelper {
    private static final JsonFactory jsonLenientCommaFactory = new JsonFactory();

    public static String stripTrailingComma(String jsonSource) throws IOException {
        JsonMapper mapper = new JsonMapper(jsonLenientCommaFactory);
        Object value = mapper.readValue(jsonSource, Object.class);
        return mapper.writeValueAsString(value);
    }

    static {
        jsonLenientCommaFactory.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
        jsonLenientCommaFactory.configure(JsonParser.Feature.ALLOW_COMMENTS, true);
        jsonLenientCommaFactory.configure(JsonFactory.Feature.FAIL_ON_SYMBOL_HASH_OVERFLOW, false);
        jsonLenientCommaFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT, false);
        jsonLenientCommaFactory.configure(JsonParser.Feature.ALLOW_TRAILING_COMMA, true);
    }
}

