/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.connector.secrets.action;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretAction;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretRequest;
import org.elasticsearch.xpack.application.connector.secrets.action.PutConnectorSecretResponse;

@ServerlessScope(value=Scope.INTERNAL)
public class RestPutConnectorSecretAction
extends BaseRestHandler {
    public String getName() {
        return "connector_secret_put_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.PUT, "/_connector/_secret/{id}"));
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutConnectorSecretRequest putSecretRequest = PutConnectorSecretRequest.fromXContentBytes(request.param("id"), (BytesReference)request.content(), request.getXContentType());
        return restChannel -> client.execute(PutConnectorSecretAction.INSTANCE, (ActionRequest)putSecretRequest, (ActionListener)new RestToXContentListener(restChannel, PutConnectorSecretResponse::status, r -> null));
    }
}

