/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ilm;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.DiffableUtils;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ilm.ErrorStep;
import org.elasticsearch.xpack.core.ilm.IndexLifecycleMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicyMetadata;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicySecurityClient;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.PhaseExecutionInfo;
import org.elasticsearch.xpack.core.ilm.Step;

public class PolicyStepsRegistry {
    private static final Logger logger = LogManager.getLogger(PolicyStepsRegistry.class);
    private final NamedXContentRegistry xContentRegistry;
    private final Client client;
    private final XPackLicenseState licenseState;
    private final SortedMap<String, LifecyclePolicyMetadata> lifecyclePolicyMap;
    private final Map<String, Step> firstStepMap;
    private final Map<String, Map<Step.StepKey, Step>> stepMap;
    private final Map<Index, Tuple<IndexMetadata, Step>> cachedSteps = new ConcurrentHashMap<Index, Tuple<IndexMetadata, Step>>();

    public PolicyStepsRegistry(NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        this(new TreeMap<String, LifecyclePolicyMetadata>(), new HashMap<String, Step>(), new HashMap<String, Map<Step.StepKey, Step>>(), xContentRegistry, client, licenseState);
    }

    PolicyStepsRegistry(SortedMap<String, LifecyclePolicyMetadata> lifecyclePolicyMap, Map<String, Step> firstStepMap, Map<String, Map<Step.StepKey, Step>> stepMap, NamedXContentRegistry xContentRegistry, Client client, XPackLicenseState licenseState) {
        this.lifecyclePolicyMap = lifecyclePolicyMap;
        this.firstStepMap = firstStepMap;
        this.stepMap = stepMap;
        this.xContentRegistry = xContentRegistry;
        this.client = client;
        this.licenseState = licenseState;
    }

    SortedMap<String, LifecyclePolicyMetadata> getLifecyclePolicyMap() {
        return this.lifecyclePolicyMap;
    }

    Map<String, Step> getFirstStepMap() {
        return this.firstStepMap;
    }

    Map<String, Map<Step.StepKey, Step>> getStepMap() {
        return this.stepMap;
    }

    public void update(IndexLifecycleMetadata meta) {
        assert (meta != null) : "IndexLifecycleMetadata cannot be null when updating the policy steps registry";
        DiffableUtils.MapDiff mapDiff = DiffableUtils.diff(this.lifecyclePolicyMap, (Map)meta.getPolicyMetadatas(), (DiffableUtils.KeySerializer)DiffableUtils.getStringKeySerializer(), (DiffableUtils.ValueSerializer)new DiffableUtils.NonDiffableValueSerializer<String, LifecyclePolicyMetadata>(this){

            public void write(LifecyclePolicyMetadata value, StreamOutput out) {
                throw new UnsupportedOperationException("should never be called");
            }

            public LifecyclePolicyMetadata read(StreamInput in, String key) {
                throw new UnsupportedOperationException("should never be called");
            }
        });
        for (String deletedPolicyName : mapDiff.getDeletes()) {
            this.lifecyclePolicyMap.remove(deletedPolicyName);
            this.firstStepMap.remove(deletedPolicyName);
            this.stepMap.remove(deletedPolicyName);
        }
        if (!mapDiff.getUpserts().isEmpty()) {
            for (Map.Entry entry : mapDiff.getUpserts()) {
                LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)entry.getValue();
                LifecyclePolicySecurityClient policyClient = new LifecyclePolicySecurityClient(this.client, "index_lifecycle", policyMetadata.getHeaders());
                this.lifecyclePolicyMap.put(policyMetadata.getName(), policyMetadata);
                List policyAsSteps = policyMetadata.getPolicy().toSteps((Client)policyClient, this.licenseState);
                if (policyAsSteps.isEmpty()) continue;
                this.firstStepMap.put(policyMetadata.getName(), (Step)policyAsSteps.get(0));
                LinkedHashMap<Step.StepKey, Step> stepMapForPolicy = new LinkedHashMap<Step.StepKey, Step>();
                for (Step step : policyAsSteps) {
                    assert (!"ERROR".equals(step.getKey().name())) : "unexpected error step in policy";
                    stepMapForPolicy.put(step.getKey(), step);
                }
                logger.trace("updating cached steps for [{}] policy, new steps: {}", (Object)policyMetadata.getName(), stepMapForPolicy.keySet());
                this.stepMap.put(policyMetadata.getName(), stepMapForPolicy);
            }
        }
        this.cachedSteps.clear();
    }

    public void delete(Index deleted) {
        this.cachedSteps.remove(deleted);
    }

    public void clear() {
        this.cachedSteps.clear();
        this.lifecyclePolicyMap.clear();
        this.firstStepMap.clear();
        this.stepMap.clear();
    }

    private List<Step> getAllStepsForIndex(ProjectMetadata project, Index index) {
        if (!project.hasIndex(index)) {
            throw new IllegalArgumentException("index " + String.valueOf(index) + " does not exist in the current cluster state");
        }
        IndexMetadata indexMetadata = project.index(index);
        String policyName = indexMetadata.getLifecyclePolicyName();
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policyName);
        if (policyMetadata == null) {
            throw new IllegalArgumentException("the policy [" + policyName + "] for index" + String.valueOf(index) + " does not exist");
        }
        LifecyclePolicySecurityClient policyClient = new LifecyclePolicySecurityClient(this.client, "index_lifecycle", policyMetadata.getHeaders());
        return policyMetadata.getPolicy().toSteps((Client)policyClient, this.licenseState);
    }

    @Nullable
    public Step.StepKey getFirstStepForPhase(ProjectMetadata project, Index index, String phase) {
        return this.getAllStepsForIndex(project, index).stream().map(Step::getKey).filter(stepKey -> phase.equals(stepKey.phase())).findFirst().orElse(null);
    }

    @Nullable
    public Step.StepKey getFirstStepForPhaseAndAction(ProjectMetadata project, Index index, String phase, String action) {
        return this.getAllStepsForIndex(project, index).stream().map(Step::getKey).filter(stepKey -> phase.equals(stepKey.phase())).filter(stepKey -> action.equals(stepKey.action())).findFirst().orElse(null);
    }

    @Nullable
    public Set<Step.StepKey> parseStepKeysFromPhase(String policy, String currentPhase, String phaseDef) {
        try {
            String phaseDefNonNull = Objects.requireNonNullElse(phaseDef, "new");
            return this.parseStepsFromPhase(policy, currentPhase, phaseDefNonNull).stream().map(Step::getKey).collect(Collectors.toSet());
        }
        catch (IOException e) {
            logger.trace(() -> Strings.format((String)"unable to parse steps for policy [%s], phase [%s], and phase definition [%s]", (Object[])new Object[]{policy, currentPhase, phaseDef}), (Throwable)e);
            return null;
        }
    }

    private List<Step> parseStepsFromPhase(String policy, String currentPhase, String phaseDef) throws IOException {
        LifecyclePolicy policyToExecute;
        LifecyclePolicyMetadata policyMetadata = (LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy);
        if (policyMetadata == null) {
            throw new IllegalStateException("unable to parse steps for policy [" + policy + "] as it doesn't exist");
        }
        LifecyclePolicy currentPolicy = policyMetadata.getPolicy();
        if ("new".equals(phaseDef) || "completed".equals(phaseDef)) {
            policyToExecute = currentPolicy;
        } else {
            PhaseExecutionInfo phaseExecutionInfo;
            try (XContentParser parser = JsonXContent.jsonXContent.createParser(XContentParserConfiguration.EMPTY.withRegistry(this.xContentRegistry), phaseDef);){
                phaseExecutionInfo = PhaseExecutionInfo.parse((XContentParser)parser, (String)currentPhase);
            }
            HashMap<String, Phase> phaseMap = new HashMap<String, Phase>(currentPolicy.getPhases());
            if (phaseExecutionInfo.getPhase() != null) {
                phaseMap.put(currentPhase, phaseExecutionInfo.getPhase());
            }
            policyToExecute = new LifecyclePolicy(currentPolicy.getType(), currentPolicy.getName(), phaseMap, currentPolicy.getMetadata());
        }
        LifecyclePolicySecurityClient policyClient = new LifecyclePolicySecurityClient(this.client, "index_lifecycle", ((LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy)).getHeaders());
        List steps = policyToExecute.toSteps((Client)policyClient, this.licenseState);
        List<Object> phaseSteps = steps == null ? List.of() : steps.stream().filter(e -> e.getKey().phase().equals(currentPhase)).toList();
        logger.trace("parsed steps for policy [{}] in phase [{}], definition: [{}], steps: [{}]", (Object)policy, (Object)currentPhase, (Object)phaseDef, phaseSteps);
        return phaseSteps;
    }

    @Nullable
    private Step getCachedStep(IndexMetadata indexMetadata, Step.StepKey stepKey) {
        Tuple<IndexMetadata, Step> cachedStep = this.cachedSteps.get(indexMetadata.getIndex());
        if (cachedStep != null && cachedStep.v1() == indexMetadata) {
            assert (cachedStep.v2() != null) : "null steps should never be cached in the policy step registry";
            if (cachedStep.v2() != null && ((Step)cachedStep.v2()).getKey().equals((Object)stepKey)) {
                return (Step)cachedStep.v2();
            }
        }
        return null;
    }

    @Nullable
    public Step getStep(IndexMetadata indexMetadata, Step.StepKey stepKey) {
        List<Step> phaseSteps;
        Step cachedStep = this.getCachedStep(indexMetadata, stepKey);
        if (cachedStep != null) {
            return cachedStep;
        }
        if ("ERROR".equals(stepKey.name())) {
            return new ErrorStep(new Step.StepKey(stepKey.phase(), stepKey.action(), "ERROR"));
        }
        String phase = stepKey.phase();
        String policyName = indexMetadata.getLifecyclePolicyName();
        Index index = indexMetadata.getIndex();
        if (policyName == null) {
            throw new IllegalArgumentException("failed to retrieve step " + String.valueOf(stepKey) + " as index [" + index.getName() + "] has no policy");
        }
        String phaseJson = Objects.requireNonNullElse(indexMetadata.getLifecycleExecutionState().phaseDefinition(), "new");
        try {
            phaseSteps = this.parseStepsFromPhase(policyName, phase, phaseJson);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to load cached steps for " + String.valueOf(stepKey), (Throwable)e, new Object[0]);
        }
        catch (XContentParseException parseErr) {
            throw new XContentParseException(parseErr.getLocation(), "failed to load steps for " + String.valueOf(stepKey) + " from [" + phaseJson + "]", (Exception)((Object)parseErr));
        }
        assert (phaseSteps.stream().allMatch(step -> step.getKey().phase().equals(phase))) : "expected phase steps loaded from phase definition for [" + index.getName() + "] to be in phase [" + phase + "] but they were not, steps: " + String.valueOf(phaseSteps);
        Step s = phaseSteps.stream().filter(step -> step.getKey().equals((Object)stepKey)).findFirst().orElse(null);
        if (s != null) {
            this.cachedSteps.put(indexMetadata.getIndex(), (Tuple<IndexMetadata, Step>)Tuple.tuple((Object)indexMetadata, (Object)s));
        }
        return s;
    }

    public boolean stepExists(String policy, Step.StepKey stepKey) {
        Map<Step.StepKey, Step> steps = this.stepMap.get(policy);
        if (steps == null) {
            return false;
        }
        return steps.containsKey(stepKey);
    }

    public boolean policyExists(String policy) {
        return this.lifecyclePolicyMap.containsKey(policy);
    }

    public Step getFirstStep(String policy) {
        return this.firstStepMap.get(policy);
    }

    public TimeValue getIndexAgeForPhase(String policy, String phase) {
        if ("new".equals(phase) || "completed".equals(phase)) {
            return TimeValue.ZERO;
        }
        LifecyclePolicyMetadata meta = (LifecyclePolicyMetadata)this.lifecyclePolicyMap.get(policy);
        if (meta == null) {
            throw new IllegalArgumentException("no policy found with name \"" + policy + "\"");
        }
        Phase retrievedPhase = (Phase)meta.getPolicy().getPhases().get(phase);
        if (retrievedPhase == null) {
            return TimeValue.ZERO;
        }
        return retrievedPhase.getMinimumAge();
    }
}

