/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchbusinessrules.retriever;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.search.Explanation;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.rank.RankDoc;

public class PinnedRankDoc
extends RankDoc {
    public static final String NAME = "pinned_rank_doc";
    private final boolean isPinned;

    public PinnedRankDoc(int docId, float score, int shardIndex, boolean isPinned) {
        super(docId, score, shardIndex);
        this.isPinned = isPinned;
    }

    public PinnedRankDoc(StreamInput in) throws IOException {
        super(in);
        this.isPinned = in.readBoolean();
    }

    public boolean isPinned() {
        return this.isPinned;
    }

    public Explanation explain(Explanation[] sources, String[] queryNames) {
        if (this.isPinned) {
            return Explanation.match((Number)Float.valueOf(this.score), (String)"Pinned document, original explanation:", (Explanation[])sources);
        }
        return super.explain(sources, queryNames);
    }

    public String toString() {
        return super.toString() + ", isPinned=" + this.isPinned;
    }

    public String getWriteableName() {
        return NAME;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.isPinned);
    }

    protected boolean doEquals(RankDoc rd) {
        if (rd instanceof PinnedRankDoc) {
            PinnedRankDoc other = (PinnedRankDoc)rd;
            return this.isPinned == other.isPinned;
        }
        return false;
    }

    protected int doHashCode() {
        return Objects.hash(super.doHashCode(), this.isPinned);
    }

    public TransportVersion getMinimalSupportedVersion() {
        throw new IllegalStateException("not used");
    }

    public boolean supportsVersion(TransportVersion version) {
        return version.onOrAfter((VersionId)TransportVersions.PINNED_RETRIEVER) || version.isPatchFrom(TransportVersions.PINNED_RETRIEVER_8_19);
    }
}

